/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.sync;

import java.util.Set;
import lombok.Generated;
import me.whereareiam.socialismus.api.input.container.PlayerContainerService;
import me.whereareiam.socialismus.api.input.event.EventListener;
import me.whereareiam.socialismus.api.input.event.EventManager;
import me.whereareiam.socialismus.api.input.event.base.SocialisticEvent;
import me.whereareiam.socialismus.api.input.event.player.DummyPlayerAddedEvent;
import me.whereareiam.socialismus.api.input.event.player.DummyPlayerRemovedEvent;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.api.output.resource.CacheService;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public final class CrossPlayerSyncBridge
implements EventListener {
    private static final String SET_KEY = "socialismus:players";
    private final CacheService cache;
    private final EventManager eventManager;
    private final PlayerContainerService localPlayers;

    public void initialize() {
        this.eventManager.register(this);
        Set<DummyPlayer> current = this.localPlayers.getPlayers();
        current.forEach(p -> this.cache.add(SET_KEY, p.getUsername()));
    }

    @SocialisticEvent
    public void onDummyPlayerAdd(DummyPlayerAddedEvent event) {
        this.cache.add(SET_KEY, event.getDummyPlayer().getUsername());
    }

    @SocialisticEvent
    public void onDummyPlayerRemove(DummyPlayerRemovedEvent event) {
        this.cache.remove(SET_KEY, event.getDummyPlayer().getUsername());
    }

    @Inject
    @Generated
    public CrossPlayerSyncBridge(CacheService cache, EventManager eventManager, PlayerContainerService localPlayers) {
        this.cache = cache;
        this.eventManager = eventManager;
        this.localPlayers = localPlayers;
    }
}

