/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.updater;

import me.whereareiam.socialismus.api.input.updater.UpdateProvider;
import me.whereareiam.socialismus.api.model.module.UpdateSpecification;
import me.whereareiam.socialismus.api.type.module.ProviderType;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.library.guice.name.Named;

@Singleton
public class UpdateProviderRegistry {
    private final UpdateProvider modrinth;
    private final UpdateProvider spigot;
    private final UpdateProvider github;

    @Inject
    public UpdateProviderRegistry(@Named(value="MODRINTH") UpdateProvider modrinth, @Named(value="SPIGOT") UpdateProvider spigot, @Named(value="GITHUB") UpdateProvider github) {
        this.modrinth = modrinth;
        this.spigot = spigot;
        this.github = github;
    }

    public UpdateProvider by(UpdateSpecification.Spec p) {
        return switch (p.getProvider()) {
            default -> throw new IncompatibleClassChangeError();
            case ProviderType.MODRINTH -> this.modrinth;
            case ProviderType.SPIGOT -> this.spigot;
            case ProviderType.GITHUB -> this.github;
        };
    }
}

