/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.common.updater.provider;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import me.whereareiam.socialismus.api.input.updater.UpdateProvider;
import me.whereareiam.socialismus.api.model.module.UpdateSpecification;
import me.whereareiam.socialismus.library.guice.Singleton;

@Singleton
public class ModrinthProvider
implements UpdateProvider {
    private final Gson gson = new Gson();

    @Override
    public Optional<String> fetchLatest(UpdateSpecification.Spec spec) throws IOException {
        URL url = URI.create("https://api.modrinth.com/v2/project/" + spec.getId() + "/version").toURL();
        try (InputStream in = url.openStream();){
            Optional<String> optional;
            try (InputStreamReader r = new InputStreamReader(in);){
                JsonArray arr = (JsonArray)this.gson.fromJson((Reader)r, JsonArray.class);
                optional = Optional.ofNullable(arr.get(0)).map(e -> e.getAsJsonObject().get("version_number").getAsString());
            }
            return optional;
        }
    }

    @Override
    public List<String> fetchRecentUpdates(UpdateSpecification.Spec spec, int limit) throws IOException {
        URL url = URI.create("https://api.modrinth.com/v2/project/" + spec.getId() + "/version?limit=" + limit).toURL();
        try (InputStream in = url.openStream();){
            ArrayList<String> arrayList;
            try (InputStreamReader r = new InputStreamReader(in);){
                JsonArray arr = (JsonArray)this.gson.fromJson((Reader)r, JsonArray.class);
                ArrayList<String> versions = new ArrayList<String>(arr.size());
                for (JsonElement e : arr) {
                    versions.add(e.getAsJsonObject().get("version_number").getAsString());
                }
                arrayList = versions;
            }
            return arrayList;
        }
    }
}

