/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.bukkit;

import me.whereareiam.socialismus.api.model.config.Settings;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.command.management.CommandExceptionHandler;
import me.whereareiam.socialismus.command.provider.CommandManagerProvider;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.platform.bukkit.mapper.CommandSenderMapper;
import org.bukkit.plugin.Plugin;
import org.incendo.cloud.CloudCapability;
import org.incendo.cloud.CommandManager;
import org.incendo.cloud.SenderMapper;
import org.incendo.cloud.bukkit.CloudBukkitCapabilities;
import org.incendo.cloud.execution.ExecutionCoordinator;
import org.incendo.cloud.paper.LegacyPaperCommandManager;

@Singleton
public class BukkitCommandManagerProvider
extends CommandManagerProvider {
    private final Plugin plugin;
    private final CommandSenderMapper commandSenderMapper;

    @Inject
    public BukkitCommandManagerProvider(CommandExceptionHandler exceptionHandler, Provider<Settings> settings, Plugin plugin, CommandSenderMapper commandSenderMapper) {
        super(settings, exceptionHandler);
        this.plugin = plugin;
        this.commandSenderMapper = commandSenderMapper;
    }

    @Override
    protected CommandManager<DummyPlayer> createLegacyPaperCommandManager() {
        LegacyPaperCommandManager commandManager = new LegacyPaperCommandManager(this.plugin, ExecutionCoordinator.asyncCoordinator(), (SenderMapper)this.commandSenderMapper);
        if (commandManager.hasCapability((CloudCapability)CloudBukkitCapabilities.ASYNCHRONOUS_COMPLETION)) {
            commandManager.registerAsynchronousCompletions();
        }
        return commandManager;
    }

    @Override
    protected CommandManager<DummyPlayer> createPaperCommandManager() {
        return this.createLegacyPaperCommandManager();
    }

    @Override
    protected CommandManager<DummyPlayer> createVelocityCommandManager() {
        throw new UnsupportedOperationException("VelocityCommandManager is not supported on Paper");
    }
}

