/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.bukkit;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import me.whereareiam.socialismus.api.model.scheduler.DelayedRunnableTask;
import me.whereareiam.socialismus.api.model.scheduler.PeriodicalRunnableTask;
import me.whereareiam.socialismus.api.model.scheduler.RunnableTask;
import me.whereareiam.socialismus.api.output.Scheduler;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

@Singleton
public class BukkitScheduler
implements Scheduler {
    private final Plugin plugin;
    private final Map<String, Map<Integer, BukkitTask>> tasks = new ConcurrentHashMap<String, Map<Integer, BukkitTask>>();
    private static final AtomicInteger ID_GENERATOR = new AtomicInteger(1);
    private static final long MS_TO_TICKS = 20L;

    @Inject
    public BukkitScheduler(Plugin plugin) {
        this.plugin = plugin;
    }

    private int ensureId(RunnableTask task) {
        int existing = task.getId();
        if (existing <= 0) {
            int generated = ID_GENERATOR.getAndIncrement();
            task.setId(generated);
            return generated;
        }
        return existing;
    }

    @Override
    public void schedule(RunnableTask runnableTask) {
        this.schedule(runnableTask, false);
    }

    @Override
    public void schedule(DelayedRunnableTask runnableTask) {
        this.schedule(runnableTask, false);
    }

    @Override
    public void schedule(PeriodicalRunnableTask runnableTask) {
        this.schedule(runnableTask, false);
    }

    @Override
    public void schedule(RunnableTask runnableTask, boolean async) {
        int id = this.ensureId(runnableTask);
        BukkitTask task = async ? Bukkit.getScheduler().runTaskAsynchronously(this.plugin, runnableTask.getRunnable()) : Bukkit.getScheduler().runTask(this.plugin, runnableTask.getRunnable());
        this.tasks.computeIfAbsent(runnableTask.getModule(), m -> new ConcurrentHashMap()).put(id, task);
    }

    @Override
    public void schedule(DelayedRunnableTask runnableTask, boolean async) {
        int id = this.ensureId(runnableTask);
        long delayInTicks = runnableTask.getDelay() / 20L;
        BukkitTask task = async ? Bukkit.getScheduler().runTaskLaterAsynchronously(this.plugin, runnableTask.getRunnable(), delayInTicks) : Bukkit.getScheduler().runTaskLater(this.plugin, runnableTask.getRunnable(), delayInTicks);
        this.tasks.computeIfAbsent(runnableTask.getModule(), m -> new ConcurrentHashMap()).put(id, task);
    }

    @Override
    public void schedule(PeriodicalRunnableTask runnableTask, boolean async) {
        int id = this.ensureId(runnableTask);
        long delayInTicks = runnableTask.getDelay() / 20L;
        long periodInTicks = runnableTask.getPeriod() / 20L;
        BukkitTask task = async ? Bukkit.getScheduler().runTaskTimerAsynchronously(this.plugin, runnableTask.getRunnable(), delayInTicks, periodInTicks) : Bukkit.getScheduler().runTaskTimer(this.plugin, runnableTask.getRunnable(), delayInTicks, periodInTicks);
        this.tasks.computeIfAbsent(runnableTask.getModule(), m -> new ConcurrentHashMap()).put(id, task);
    }

    @Override
    public void cancel(RunnableTask runnableTask) {
        Map<Integer, BukkitTask> moduleTasks = this.tasks.get(runnableTask.getModule());
        if (moduleTasks != null) {
            Integer id = runnableTask.getId();
            BukkitTask t = moduleTasks.remove(id);
            if (t != null) {
                t.cancel();
            }
            if (moduleTasks.isEmpty()) {
                this.tasks.remove(runnableTask.getModule());
            }
        }
    }

    @Override
    public void cancel(DelayedRunnableTask runnableTask) {
        this.cancel((RunnableTask)runnableTask);
    }

    @Override
    public void cancelByModule(String module) {
        Map<Integer, BukkitTask> moduleTasks = this.tasks.remove(module);
        if (moduleTasks != null) {
            moduleTasks.values().forEach(BukkitTask::cancel);
        }
    }
}

