/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.bukkit;

import java.nio.file.Path;
import java.util.logging.Logger;
import me.whereareiam.socialismus.api.type.PluginType;
import me.whereareiam.socialismus.common.CommonInjector;
import me.whereareiam.socialismus.common.CommonSocialismus;
import me.whereareiam.socialismus.common.IntegrityChecker;
import me.whereareiam.socialismus.integration.bstats.bStatsIntegration;
import me.whereareiam.socialismus.integration.packetevents.PacketEventsIntegration;
import me.whereareiam.socialismus.integration.placeholderapi.PlaceholderAPIIntegration;
import me.whereareiam.socialismus.platform.BukkitLoggingHelper;
import me.whereareiam.socialismus.platform.bukkit.BukkitDependencyResolver;
import me.whereareiam.socialismus.platform.bukkit.inject.BukkitInjector;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class BukkitSocialismus
extends JavaPlugin {
    private final CommonSocialismus commonSocialismus = new CommonSocialismus();
    private final Path dataPath = this.getDataFolder().toPath();
    private final Logger logger = this.getLogger();

    public void onLoad() {
        PluginType.setPluginType(PluginType.BUKKIT);
        BukkitLoggingHelper.setLogger(this.logger);
        BukkitDependencyResolver dependencyResolver = new BukkitDependencyResolver((Plugin)this);
        dependencyResolver.loadLibraries();
        dependencyResolver.resolveDependencies();
        new BukkitInjector((Plugin)this, dependencyResolver, this.dataPath);
        this.commonSocialismus.onLoad();
        if (((IntegrityChecker)CommonInjector.getInjector().getInstance(IntegrityChecker.class)).checkIntegrity()) {
            this.getPluginLoader().disablePlugin((Plugin)this);
        }
    }

    public void onEnable() {
        CommonInjector.getInjector().getInstance(PlaceholderAPIIntegration.class);
        CommonInjector.getInjector().getInstance(PacketEventsIntegration.class);
        CommonInjector.getInjector().getInstance(bStatsIntegration.class);
        this.commonSocialismus.onEnable();
    }

    public void onDisable() {
        this.commonSocialismus.onDisable();
    }
}

