/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.bukkit.listener;

import me.whereareiam.socialismus.api.Logger;
import me.whereareiam.socialismus.api.model.config.Settings;
import me.whereareiam.socialismus.api.output.listener.DynamicListener;
import me.whereareiam.socialismus.common.CommonListenerRegistrar;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Injector;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import me.whereareiam.socialismus.platform.bukkit.listener.chat.PlayerChatListener;
import me.whereareiam.socialismus.platform.bukkit.listener.connection.PlayerJoinListener;
import me.whereareiam.socialismus.platform.bukkit.listener.connection.PlayerLoginListener;
import me.whereareiam.socialismus.platform.listener.activity.PlayerWorldChangeListener;
import me.whereareiam.socialismus.platform.listener.connection.PlayerQuitListener;
import me.whereareiam.socialismus.platform.util.BukkitUtil;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

@Singleton
public class BukkitListenerRegistrar
extends CommonListenerRegistrar {
    private final Injector injector;
    private final Plugin plugin;
    private final PluginManager pluginManager;

    @Inject
    public BukkitListenerRegistrar(Injector injector, Provider<Settings> settingsProvider, Plugin plugin, PluginManager pluginManager) {
        super(settingsProvider);
        this.injector = injector;
        this.plugin = plugin;
        this.pluginManager = pluginManager;
    }

    @Override
    public void registerListeners() {
        this.registerListener(AsyncPlayerChatEvent.class, (DynamicListener)this.injector.getInstance(PlayerChatListener.class));
        this.registerListener(PlayerChangedWorldEvent.class, (DynamicListener)this.injector.getInstance(PlayerWorldChangeListener.class));
        this.registerListener(PlayerQuitEvent.class, (DynamicListener)this.injector.getInstance(PlayerQuitListener.class));
        this.registerListener(PlayerJoinEvent.class, (DynamicListener)this.injector.getInstance(PlayerJoinListener.class));
        this.registerListener(PlayerLoginEvent.class, (DynamicListener)this.injector.getInstance(PlayerLoginListener.class));
    }

    @Override
    public <T> void registerListener(Class<T> eventClass, DynamicListener<T> listener) {
        if (((Settings)this.settings.get()).getListeners().getEvents().get(eventClass.getName()) == null || !((Settings)this.settings.get()).getListeners().getEvents().get(eventClass.getName()).isRegister()) {
            return;
        }
        Logger.debug("Registering listener for event " + eventClass.getName(), new Object[0]);
        this.pluginManager.registerEvent(eventClass, new Listener(){}, BukkitUtil.of(this.determinePriority(eventClass)), (l, e) -> listener.onEvent(eventClass.cast(e)), this.plugin);
    }
}

