/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.bukkit.listener.chat;

import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import me.whereareiam.socialismus.api.model.chat.message.ChatMessage;
import me.whereareiam.socialismus.api.model.chat.message.FormattedChatMessage;
import me.whereareiam.socialismus.api.output.listener.DynamicListener;
import me.whereareiam.socialismus.api.util.ComponentUtil;
import me.whereareiam.socialismus.common.chat.ChatCoordinator;
import me.whereareiam.socialismus.common.chat.ChatMessageFactory;
import me.whereareiam.socialismus.common.chat.broadcast.ChatBroadcaster;
import me.whereareiam.socialismus.library.adventure.text.Component;
import me.whereareiam.socialismus.library.adventure.text.TextComponent;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Singleton;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.AsyncPlayerChatEvent;

@Singleton
public class PlayerChatListener
implements DynamicListener<AsyncPlayerChatEvent> {
    private final ChatCoordinator chatCoordinator;
    private final ChatBroadcaster chatBroadcaster;
    private final ChatMessageFactory chatMessageFactory;

    @Override
    public void onEvent(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        Set recipients = event.getRecipients();
        TextComponent content = Component.text((String)event.getMessage());
        ChatMessage chatMessage = this.chatMessageFactory.createChatMessage(player.getUniqueId(), recipients.stream().map(Entity::getUniqueId).collect(Collectors.toSet()), (Component)content);
        FormattedChatMessage formattedChatMessage = this.chatCoordinator.coordinate(chatMessage);
        if (formattedChatMessage == null || formattedChatMessage.isCancelled() || !formattedChatMessage.isVanillaSending()) {
            event.setCancelled(true);
            return;
        }
        event.getRecipients().clear();
        event.getRecipients().addAll(formattedChatMessage.getRecipients().stream().map(recipient -> player.getServer().getPlayer(recipient.getUniqueId())).collect(Collectors.toSet()));
        event.setFormat(ComponentUtil.toLegacy(formattedChatMessage.getFormat().replaceText(this.chatBroadcaster.createClearReplacement(formattedChatMessage, player.getUniqueId())), true).replace("{message}", "%2$s"));
        event.setMessage(ComponentUtil.toLegacy(formattedChatMessage.getContent(), true));
    }

    @Inject
    @Generated
    public PlayerChatListener(ChatCoordinator chatCoordinator, ChatBroadcaster chatBroadcaster, ChatMessageFactory chatMessageFactory) {
        this.chatCoordinator = chatCoordinator;
        this.chatBroadcaster = chatBroadcaster;
        this.chatMessageFactory = chatMessageFactory;
    }
}

