/*
 * Decompiled with CFR 0.152.
 */
package me.whereareiam.socialismus.platform.bukkit.mapper;

import java.util.Optional;
import javax.annotation.Nonnull;
import me.whereareiam.socialismus.api.input.container.PlayerContainerService;
import me.whereareiam.socialismus.api.model.player.DummyCommandPlayer;
import me.whereareiam.socialismus.api.model.player.DummyPlayer;
import me.whereareiam.socialismus.library.adventure.platform.bukkit.BukkitAudiences;
import me.whereareiam.socialismus.library.guice.Inject;
import me.whereareiam.socialismus.library.guice.Provider;
import me.whereareiam.socialismus.library.guice.Singleton;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.incendo.cloud.SenderMapper;

@Singleton
public class CommandSenderMapper
implements SenderMapper<CommandSender, DummyPlayer> {
    private final PlayerContainerService playerContainer;
    private final Provider<BukkitAudiences> audiences;

    @Inject
    public CommandSenderMapper(PlayerContainerService playerContainer, Provider<BukkitAudiences> audiences) {
        this.playerContainer = playerContainer;
        this.audiences = audiences;
    }

    public @NonNull DummyPlayer map(@NonNull CommandSender source) {
        if (source instanceof ConsoleCommandSender) {
            return ((DummyCommandPlayer.DummyCommandPlayerBuilder)((DummyPlayer.DummyPlayerBuilder)DummyCommandPlayer.builder().commandSender(source)).audience(((BukkitAudiences)this.audiences.get()).sender(source))).build();
        }
        Optional<DummyPlayer> dummyPlayer = this.playerContainer.getPlayer(source.getName());
        if (dummyPlayer.isPresent()) {
            return DummyCommandPlayer.from(dummyPlayer.get(), source);
        }
        throw new NullPointerException("A player with the name " + source.getName() + " was not found");
    }

    @Nonnull
    public CommandSender reverse(@Nonnull DummyPlayer dummyPlayer) {
        return (CommandSender)((DummyCommandPlayer)dummyPlayer).getCommandSender();
    }
}

