/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.handler;

import ca.teamdman.sfm.client.screen.SFMFontUtils;
import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.item.NetworkToolItem;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.util.HelpsWithMinecraftVersionIndependence;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.SFMDirections;
import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

@EventBusSubscriber(modid="sfm", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ItemWorldRenderer {
    private static final int BUFFER_SIZE = 256;
    private static final RenderType RENDER_TYPE = RenderType.create((String)"sfm_overlay", (VertexFormat)DefaultVertexFormat.POSITION_COLOR, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.builder().setTextureState((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(TextureAtlas.LOCATION_BLOCKS, false, false)).setDepthTestState(new RenderStateShard.DepthTestStateShard("always", 519)).setTransparencyState(new RenderStateShard.TransparencyStateShard("src_to_one", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    })).createCompositeState(true));
    private static final int capabilityColor = FastColor.ARGB32.color((int)100, (int)100, (int)0, (int)255);
    private static final int capabilityColorLimitedView = FastColor.ARGB32.color((int)100, (int)0, (int)100, (int)255);
    private static final int cableColor = FastColor.ARGB32.color((int)100, (int)100, (int)255, (int)0);
    private static final VBOCache vboCache = new VBOCache();

    @SubscribeEvent
    public static void renderOverlays(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        Camera camera = minecraft.gameRenderer.getMainCamera();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        boolean rendered = false;
        ItemStack held = ItemWorldRenderer.getHeldItemOfType(player, NetworkToolItem.class);
        if (held != null) {
            ItemWorldRenderer.handleNetworkTool(event, poseStack, camera, bufferSource, held);
            rendered = true;
        }
        if ((held = ItemWorldRenderer.getHeldItemOfType(player, LabelGunItem.class)) != null) {
            ItemWorldRenderer.handleLabelGun(event, poseStack, camera, bufferSource, held);
            rendered = true;
        }
        if (!rendered) {
            vboCache.clear();
        }
    }

    @Nullable
    public static BlockPos lookingAt() {
        HitResult rt = Minecraft.getInstance().hitResult;
        if (rt == null) {
            return null;
        }
        double x = rt.getLocation().x;
        double y = rt.getLocation().y;
        double z = rt.getLocation().z;
        LocalPlayer player = Minecraft.getInstance().player;
        assert (player != null);
        Vec3 lookAngle = player.getLookAngle();
        double xla = lookAngle.x;
        double yla = lookAngle.y;
        double zla = lookAngle.z;
        if (x % 1.0 == 0.0 && xla < 0.0) {
            x -= 0.01;
        }
        if (y % 1.0 == 0.0 && yla < 0.0) {
            y -= 0.01;
        }
        if (z % 1.0 == 0.0 && zla < 0.0) {
            z -= 0.01;
        }
        return new BlockPos((int)Math.floor(x), (int)Math.floor(y), (int)Math.floor(z));
    }

    @Nullable
    private static ItemStack getHeldItemOfType(LocalPlayer player, Class<?> itemClass) {
        ItemStack mainHandItem = player.getMainHandItem();
        if (itemClass.isInstance(mainHandItem.getItem())) {
            return mainHandItem;
        }
        ItemStack offhandItem = player.getOffhandItem();
        if (itemClass.isInstance(offhandItem.getItem())) {
            return offhandItem;
        }
        return null;
    }

    private static void handleLabelGun(RenderLevelStageEvent event, PoseStack poseStack, Camera camera, MultiBufferSource.BufferSource bufferSource, ItemStack labelGun) {
        LabelGunItem.LabelGunViewMode viewMode = LabelGunItem.getViewMode(labelGun);
        LabelPositionHolder labelPositionHolder = LabelPositionHolder.from(labelGun);
        HashMultimap labelsByPosition = HashMultimap.create();
        String activeLabel = LabelGunItem.getActiveLabel(labelGun);
        BlockPos lookingAtPos = ItemWorldRenderer.lookingAt();
        switch (viewMode) {
            case SHOW_ALL: {
                labelPositionHolder.forEach((label, pos) -> labelsByPosition.put(pos, label));
                break;
            }
            case SHOW_ONLY_ACTIVE_LABEL_AND_TARGETED_BLOCK: {
                if (!activeLabel.isEmpty()) {
                    labelPositionHolder.forEach((label, pos) -> {
                        if (label.equals(activeLabel)) {
                            labelsByPosition.put(pos, label);
                        }
                    });
                }
                if (lookingAtPos == null) break;
                for (String string : labelPositionHolder.getLabels(lookingAtPos)) {
                    labelsByPosition.put((Object)lookingAtPos, (Object)string);
                }
                break;
            }
            case SHOW_ONLY_TARGETED_BLOCK: {
                if (lookingAtPos == null) break;
                for (String string : labelPositionHolder.getLabels(lookingAtPos)) {
                    labelsByPosition.put((Object)lookingAtPos, (Object)string);
                }
                break;
            }
        }
        RenderSystem.disableDepthTest();
        poseStack.pushPose();
        poseStack.translate(-camera.getPosition().x, -camera.getPosition().y, -camera.getPosition().z);
        for (Map.Entry entry : labelsByPosition.asMap().entrySet()) {
            BlockPos pos2 = (BlockPos)entry.getKey();
            Collection labels = (Collection)entry.getValue();
            ItemWorldRenderer.drawLabelsForPos(poseStack, camera, pos2, (MultiBufferSource)bufferSource, labels);
        }
        poseStack.popPose();
        RENDER_TYPE.setupRenderState();
        Set labelledPositions = labelsByPosition.keySet();
        ItemWorldRenderer.drawVbo(VBOKind.LABEL_GUN_CAPABILITIES, poseStack, labelledPositions, viewMode != LabelGunItem.LabelGunViewMode.SHOW_ALL ? capabilityColorLimitedView : capabilityColor, event);
        RENDER_TYPE.clearRenderState();
        bufferSource.endBatch();
        RenderSystem.enableDepthTest();
    }

    private static void handleNetworkTool(RenderLevelStageEvent event, PoseStack poseStack, Camera ignoredCamera, MultiBufferSource.BufferSource bufferSource, ItemStack networkTool) {
        if (!NetworkToolItem.getOverlayEnabled(networkTool)) {
            return;
        }
        Set<BlockPos> cablePositions = NetworkToolItem.getCablePositions(networkTool);
        Set<BlockPos> capabilityPositions = NetworkToolItem.getCapabilityProviderPositions(networkTool);
        RenderSystem.disableDepthTest();
        RENDER_TYPE.setupRenderState();
        ItemWorldRenderer.drawVbo(VBOKind.NETWORK_TOOL_CABLES, poseStack, cablePositions, cableColor, event);
        ItemWorldRenderer.drawVbo(VBOKind.NETWORK_TOOL_CAPABILITIES, poseStack, capabilityPositions, capabilityColor, event);
        RENDER_TYPE.clearRenderState();
        bufferSource.endBatch();
        RenderSystem.enableDepthTest();
    }

    private static void drawVbo(VBOKind vboKind, PoseStack poseStack, Set<BlockPos> positions, int color, RenderLevelStageEvent event) {
        VertexBuffer vbo = vboCache.getVBO(vboKind, positions, event, FastColor.ARGB32.red((int)color), FastColor.ARGB32.green((int)color), FastColor.ARGB32.blue((int)color), FastColor.ARGB32.alpha((int)color));
        if (vbo != null) {
            poseStack.pushPose();
            poseStack.mulPose(event.getCamera().rotation().invert(new Quaternionf()));
            poseStack.translate(-event.getCamera().getPosition().x, -event.getCamera().getPosition().y, -event.getCamera().getPosition().z);
            vbo.bind();
            assert (GameRenderer.getPositionColorShader() != null);
            vbo.drawWithShader(poseStack.last().pose(), event.getProjectionMatrix(), GameRenderer.getPositionColorShader());
            VertexBuffer.unbind();
            poseStack.popPose();
        }
    }

    private static void drawLabelsForPos(PoseStack poseStack, Camera camera, @NotStored BlockPos pos, MultiBufferSource mbs, Collection<String> labels) {
        poseStack.pushPose();
        poseStack.translate((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
        poseStack.mulPose(camera.rotation());
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        poseStack.scale(-0.025f, -0.025f, 0.025f);
        Font font = Minecraft.getInstance().font;
        double d = labels.size();
        Objects.requireNonNull(font);
        poseStack.translate(0.0, d * (9.0 + 0.1) / -2.0, 0.0);
        for (String label : labels) {
            SFMFontUtils.drawInBatch(label, font, (float)(-font.width(label)) / 2.0f, 0.0f, false, true, poseStack.last().pose(), mbs);
            Objects.requireNonNull(font);
            poseStack.translate(0.0, 9.0 + 0.1, 0.0);
        }
        poseStack.popPose();
    }

    @HelpsWithMinecraftVersionIndependence
    private static void writeVertex(VertexConsumer builder, Matrix4f matrix4f, float x, float y, float z, int r, int g, int b, int a) {
        builder.addVertex(matrix4f, x, y, z).setColor(r, g, b, a);
    }

    private static void writeFaceVertices(VertexConsumer builder, Matrix4f matrix4f, Direction direction, int r, int g, int b, int a) {
        double scale = 1.0 - (double)direction.ordinal() / 25.0;
        r = (int)((double)r * scale);
        g = (int)((double)g * scale);
        b = (int)((double)b * scale);
        a = (int)((double)a * scale);
        switch (direction) {
            case DOWN: {
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 0.0f, 0.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 0.0f, 0.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 0.0f, 1.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 0.0f, 1.0f, r, g, b, a);
                break;
            }
            case UP: {
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 1.0f, 1.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 1.0f, 1.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 1.0f, 0.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 1.0f, 0.0f, r, g, b, a);
                break;
            }
            case NORTH: {
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 0.0f, 0.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 1.0f, 0.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 1.0f, 0.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 0.0f, 0.0f, r, g, b, a);
                break;
            }
            case SOUTH: {
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 0.0f, 1.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 1.0f, 1.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 1.0f, 1.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 0.0f, 1.0f, r, g, b, a);
                break;
            }
            case WEST: {
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 0.0f, 1.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 1.0f, 1.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 1.0f, 0.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 0.0f, 0.0f, 0.0f, r, g, b, a);
                break;
            }
            case EAST: {
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 0.0f, 0.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 1.0f, 0.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 1.0f, 1.0f, r, g, b, a);
                ItemWorldRenderer.writeVertex(builder, matrix4f, 1.0f, 0.0f, 1.0f, r, g, b, a);
            }
        }
    }

    private static class VBOCache {
        private final EnumMap<VBOKind, VBOEntry> cache = new EnumMap(VBOKind.class);
        private int lastChangeCheck = -1;

        private VBOCache() {
        }

        @Nullable
        public VertexBuffer getVBO(VBOKind kind, Set<BlockPos> positions, RenderLevelStageEvent event, int r, int g, int b, int a) {
            boolean shouldRebuild;
            if (positions.isEmpty()) {
                return null;
            }
            @Nullable VBOEntry entry = this.cache.get((Object)kind);
            boolean bl = shouldRebuild = entry == null;
            if (entry != null && event.getRenderTick() != this.lastChangeCheck && !entry.positions.equals(positions)) {
                this.lastChangeCheck = event.getRenderTick();
                shouldRebuild = true;
            }
            if (shouldRebuild) {
                if (entry != null) {
                    entry.vbo.close();
                }
                VertexBuffer vbo = this.createVBO(positions, r, g, b, a);
                entry = new VBOEntry(new HashSet<BlockPos>(positions), vbo);
                this.cache.put(kind, entry);
            }
            return entry.vbo;
        }

        public void clear() {
            for (VBOEntry entry : this.cache.values()) {
                entry.vbo.close();
            }
            this.cache.clear();
        }

        @HelpsWithMinecraftVersionIndependence
        private BufferBuilder createBufferBuilder(int numPositions) {
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(RENDER_TYPE.mode(), RENDER_TYPE.format());
            return bufferBuilder;
        }

        private VertexBuffer createVBO(Set<BlockPos> positions, int r, int g, int b, int a) {
            PoseStack poseStack = new PoseStack();
            BufferBuilder bufferBuilder = this.createBufferBuilder(positions.size());
            for (BlockPos blockPos : positions) {
                poseStack.pushPose();
                poseStack.translate((float)blockPos.getX(), (float)blockPos.getY(), (float)blockPos.getZ());
                Matrix4f matrix4f = poseStack.last().pose();
                for (Direction face : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
                    if (positions.contains(blockPos.relative(face))) continue;
                    ItemWorldRenderer.writeFaceVertices((VertexConsumer)bufferBuilder, matrix4f, face, r, g, b, a);
                }
                poseStack.popPose();
            }
            MeshData meshData = bufferBuilder.buildOrThrow();
            VertexBuffer vbo = new VertexBuffer(VertexBuffer.Usage.STATIC);
            vbo.bind();
            vbo.upload(meshData);
            VertexBuffer.unbind();
            return vbo;
        }

        private record VBOEntry(Set<BlockPos> positions, VertexBuffer vbo) {
        }
    }

    private static enum VBOKind {
        LABEL_GUN_CAPABILITIES,
        NETWORK_TOOL_CAPABILITIES,
        NETWORK_TOOL_CABLES;

    }
}

