/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.registry;

import ca.teamdman.sfm.common.localization.LocalizationKeys;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.settings.IKeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyConflictContext;
import net.neoforged.neoforge.client.settings.KeyModifier;
import net.neoforged.neoforge.common.util.Lazy;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, modid="sfm", value={Dist.CLIENT})
public class SFMKeyMappings {
    public static final Lazy<KeyMapping> MORE_INFO_TOOLTIP_KEY = Lazy.of(() -> new KeyMapping(LocalizationKeys.MORE_HOVER_INFO_KEY.key().get(), (IKeyConflictContext)KeyConflictContext.UNIVERSAL, InputConstants.Type.KEYSYM, 340, LocalizationKeys.SFM_KEY_CATEGORY.key().get()));
    public static final Lazy<KeyMapping> CYCLE_LABEL_VIEW_KEY = Lazy.of(() -> new KeyMapping(LocalizationKeys.CYCLE_LABEL_VIEW_KEY.key().get(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 342, LocalizationKeys.SFM_KEY_CATEGORY.key().get()));
    public static final Lazy<KeyMapping> TOGGLE_NETWORK_TOOL_OVERLAY_KEY = Lazy.of(() -> new KeyMapping(LocalizationKeys.TOGGLE_NETWORK_TOOL_OVERLAY.key().get(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 342, LocalizationKeys.SFM_KEY_CATEGORY.key().get()));
    public static final Lazy<KeyMapping> CONTAINER_INSPECTOR_KEY = Lazy.of(() -> new KeyMapping(LocalizationKeys.CONTAINER_INSPECTOR_TOGGLE_KEY.key().get(), (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.CONTROL, InputConstants.Type.KEYSYM, 73, LocalizationKeys.SFM_KEY_CATEGORY.key().get()));
    public static final Lazy<KeyMapping> ITEM_INSPECTOR_KEY = Lazy.of(() -> new KeyMapping(LocalizationKeys.ITEM_INSPECTOR_TOGGLE_KEY.key().get(), (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.NONE, InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), LocalizationKeys.SFM_KEY_CATEGORY.key().get()));
    public static final Lazy<KeyMapping> LABEL_GUN_PICK_BLOCK_MODIFIER_KEY = Lazy.of(() -> new KeyMapping(LocalizationKeys.LABEL_GUN_PICK_BLOCK_MODIFIER_KEY.key().get(), (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 342, LocalizationKeys.SFM_KEY_CATEGORY.key().get()));
    public static final Lazy<KeyMapping> LABEL_GUN_CONTIGUOUS_MODIFIER_KEY = Lazy.of(() -> new KeyMapping(LocalizationKeys.LABEL_GUN_CONTIGUOUS_MODIFIER_KEY.key().get(), (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 341, LocalizationKeys.SFM_KEY_CATEGORY.key().get()));
    public static final Lazy<KeyMapping> LABEL_GUN_CLEAR_MODIFIER_KEY = Lazy.of(() -> new KeyMapping(LocalizationKeys.LABEL_GUN_CLEAR_MODIFIER_KEY.key().get(), (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 340, LocalizationKeys.SFM_KEY_CATEGORY.key().get()));
    public static final Lazy<KeyMapping> LABEL_GUN_SCROLL_MODIFIER_KEY = Lazy.of(() -> new KeyMapping(LocalizationKeys.LABEL_GUN_SCROLL_MODIFIER_KEY.key().get(), (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 340, LocalizationKeys.SFM_KEY_CATEGORY.key().get()));
    public static final Lazy<KeyMapping> LABEL_GUN_NEXT_LABEL_KEY = Lazy.of(() -> new KeyMapping(LocalizationKeys.LABEL_GUN_NEXT_LABEL_KEY.key().get(), (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), LocalizationKeys.SFM_KEY_CATEGORY.key().get()));
    public static final Lazy<KeyMapping> LABEL_GUN_PREVIOUS_LABEL_KEY = Lazy.of(() -> new KeyMapping(LocalizationKeys.LABEL_GUN_PREVIOUS_LABEL_KEY.key().get(), (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), LocalizationKeys.SFM_KEY_CATEGORY.key().get()));
    public static final Lazy<KeyMapping> LABEL_GUN_PULL_MODIFIER_KEY = Lazy.of(() -> new KeyMapping(LocalizationKeys.LABEL_GUN_PULL_MODIFIER_KEY.key().get(), (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 340, LocalizationKeys.SFM_KEY_CATEGORY.key().get()));
    public static final Lazy<KeyMapping> LABEL_GUN_TARGET_MANAGER_MODIFIER_KEY = Lazy.of(() -> new KeyMapping(LocalizationKeys.LABEL_GUN_TARGET_MANAGER_MODIFIER_KEY.key().get(), (IKeyConflictContext)KeyConflictContext.IN_GAME, KeyModifier.NONE, InputConstants.Type.KEYSYM, 346, LocalizationKeys.SFM_KEY_CATEGORY.key().get()));
    public static final Lazy<KeyMapping> MANAGER_SCREEN_OPEN_TEXT_EDITOR_KEY = Lazy.of(() -> new KeyMapping(LocalizationKeys.MANAGER_SCREEN_OPEN_TEXT_EDITOR_KEY.key().get(), (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.CONTROL, InputConstants.Type.KEYSYM, 69, LocalizationKeys.SFM_KEY_CATEGORY.key().get()));
    public static final Lazy<KeyMapping> TITLE_SCREEN_OPEN_TEXT_EDITOR_KEY = Lazy.of(() -> new KeyMapping(LocalizationKeys.TITLE_SCREEN_OPEN_TEXT_EDITOR_KEY.key().get(), (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.CONTROL, InputConstants.Type.KEYSYM, 69, LocalizationKeys.SFM_KEY_CATEGORY.key().get()));

    public static KeyMapping[] getSFMKeyMappings() {
        return new KeyMapping[]{(KeyMapping)MORE_INFO_TOOLTIP_KEY.get(), (KeyMapping)CONTAINER_INSPECTOR_KEY.get(), (KeyMapping)ITEM_INSPECTOR_KEY.get(), (KeyMapping)CYCLE_LABEL_VIEW_KEY.get(), (KeyMapping)LABEL_GUN_PICK_BLOCK_MODIFIER_KEY.get(), (KeyMapping)LABEL_GUN_CONTIGUOUS_MODIFIER_KEY.get(), (KeyMapping)LABEL_GUN_CLEAR_MODIFIER_KEY.get(), (KeyMapping)LABEL_GUN_SCROLL_MODIFIER_KEY.get(), (KeyMapping)LABEL_GUN_NEXT_LABEL_KEY.get(), (KeyMapping)LABEL_GUN_PREVIOUS_LABEL_KEY.get(), (KeyMapping)LABEL_GUN_PULL_MODIFIER_KEY.get(), (KeyMapping)LABEL_GUN_TARGET_MANAGER_MODIFIER_KEY.get(), (KeyMapping)MANAGER_SCREEN_OPEN_TEXT_EDITOR_KEY.get(), (KeyMapping)TITLE_SCREEN_OPEN_TEXT_EDITOR_KEY.get(), (KeyMapping)TOGGLE_NETWORK_TOOL_OVERLAY_KEY.get()};
    }

    public static Component getKeyDisplay(KeyMapping key) {
        return key.getTranslatedKeyMessage().plainCopy().withStyle(ChatFormatting.AQUA);
    }

    public static Component getKeyDisplay(Supplier<KeyMapping> key) {
        return SFMKeyMappings.getKeyDisplay(key.get());
    }

    @SubscribeEvent
    public static void registerBindings(RegisterKeyMappingsEvent event) {
        for (KeyMapping key : SFMKeyMappings.getSFMKeyMappings()) {
            event.register(key);
        }
    }

    public static boolean isKeyDown(Supplier<KeyMapping> key) {
        KeyMapping keyMapping = key.get();
        if (keyMapping.getKey().equals((Object)InputConstants.UNKNOWN)) {
            return false;
        }
        long windowHandle = Minecraft.getInstance().getWindow().getWindow();
        boolean keyDown = InputConstants.isKeyDown((long)windowHandle, (int)keyMapping.getKey().getValue());
        if (!keyDown) {
            return false;
        }
        if (KeyModifier.isKeyCodeModifier((InputConstants.Key)keyMapping.getKey())) {
            return true;
        }
        return keyMapping.getKeyModifier().isActive((IKeyConflictContext)KeyConflictContext.GUI);
    }
}

