/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.cablenetwork;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.ICableBlock;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.SFMDirections;
import ca.teamdman.sfm.common.util.SFMStreamUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="sfm")
public class CableNetworkManager {
    private static final Map<Level, Long2ObjectMap<CableNetwork>> NETWORKS_BY_CABLE_POSITION = new Object2ObjectOpenHashMap();
    private static final Map<Level, List<CableNetwork>> NETWORKS_BY_LEVEL = new Object2ObjectOpenHashMap();

    private static void onNetworkLookupChanged() {
    }

    public static Optional<CableNetwork> getOrRegisterNetworkFromManagerPosition(ManagerBlockEntity tile) {
        Level level = tile.getLevel();
        assert (level != null);
        return CableNetworkManager.getOrRegisterNetworkFromCablePosition(level, tile.getBlockPos());
    }

    public static Stream<CableNetwork> getNetworksForLevel(Level level) {
        if (level.isClientSide()) {
            return Stream.empty();
        }
        return NETWORKS_BY_LEVEL.getOrDefault(level, Collections.emptyList()).stream();
    }

    public static Stream<CableNetwork> getNetworksInRange(Level level, @NotStored BlockPos pos, double maxDistance) {
        if (level.isClientSide()) {
            return Stream.empty();
        }
        return CableNetworkManager.getNetworksForLevel(level).filter(net -> net.getCablePositions().anyMatch(cablePos -> cablePos.distSqr((Vec3i)pos) < maxDistance * maxDistance));
    }

    public static void unregisterNetworkForTestingPurposes(CableNetwork network) {
        CableNetworkManager.removeNetwork(network);
    }

    public static void onCablePlaced(Level level, @NotStored BlockPos pos) {
        if (level.isClientSide()) {
            return;
        }
        CableNetworkManager.getOrRegisterNetworkFromCablePosition(level, pos);
    }

    public static void onCableRemoved(Level level, @NotStored BlockPos cablePos) {
        CableNetworkManager.getNetworkFromCablePosition(level, cablePos).ifPresent(network -> {
            CableNetworkManager.removeNetwork(network);
            if (network.getCableCount() <= 256) {
                List<CableNetwork> remainingNetworks = network.withoutCable(cablePos);
                remainingNetworks.forEach(CableNetworkManager::addNetwork);
            }
        });
    }

    public static void purgeCableNetworkForManager(ManagerBlockEntity manager) {
        CableNetworkManager.getNetworkFromCablePosition(manager.getLevel(), manager.getBlockPos()).ifPresent(CableNetworkManager::removeNetwork);
    }

    public static Optional<CableNetwork> getOrRegisterNetworkFromCablePosition(Level level, @NotStored BlockPos pos) {
        CableNetwork rtn;
        if (level.isClientSide()) {
            return Optional.empty();
        }
        Optional<CableNetwork> existing = CableNetworkManager.getNetworkFromCablePosition(level, pos);
        if (existing.isPresent()) {
            return existing;
        }
        if (!CableNetwork.isCable(level, pos)) {
            return Optional.empty();
        }
        ArrayDeque<BlockPos> danglingCables = new ArrayDeque<BlockPos>(6);
        HashSet<CableNetwork> neighbouringNetworks = new HashSet<CableNetwork>();
        BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
        for (Direction direction : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
            target.set((Vec3i)pos).move(direction);
            Optional<CableNetwork> found = CableNetworkManager.getNetworkFromCablePosition(level, (BlockPos)target);
            if (found.isPresent()) {
                neighbouringNetworks.add(found.get());
                continue;
            }
            if (!CableNetwork.isCable(level, (BlockPos)target)) continue;
            danglingCables.add(target.immutable());
        }
        if (neighbouringNetworks.isEmpty()) {
            CableNetwork network = new CableNetwork(level);
            network.rebuildNetwork(pos);
            CableNetworkManager.addNetwork(network);
            return Optional.of(network);
        }
        List<CableNetwork> networksByLevel = NETWORKS_BY_LEVEL.get(level);
        Long2ObjectMap<CableNetwork> networksByPosition = NETWORKS_BY_CABLE_POSITION.get(level);
        if (neighbouringNetworks.size() == 1) {
            rtn = (CableNetwork)neighbouringNetworks.iterator().next();
        } else {
            Iterator iterator = neighbouringNetworks.iterator();
            rtn = (CableNetwork)iterator.next();
            while (iterator.hasNext()) {
                CableNetwork other = (CableNetwork)iterator.next();
                rtn.mergeNetwork(other);
                networksByLevel.remove(other);
                other.getCablePositionsRaw().forEach(cablePos -> networksByPosition.put(cablePos, (Object)rtn));
            }
        }
        rtn.addCable(pos);
        networksByPosition.put(pos.asLong(), (Object)rtn);
        HashSet visitDebounce = new HashSet();
        Set allDanglingCables = SFMStreamUtils.getRecursiveStream((current, next, results) -> {
            results.accept(current);
            BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
            for (Direction d : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
                target.set((Vec3i)current).move(d);
                if (!CableNetwork.isCable(rtn.getLevel(), (BlockPos)target) || rtn.containsCablePosition((BlockPos)target)) continue;
                next.accept(target.immutable());
            }
        }, visitDebounce, danglingCables).collect(Collectors.toSet());
        for (BlockPos danglingCable : allDanglingCables) {
            rtn.addCable(danglingCable);
            networksByPosition.put(danglingCable.asLong(), (Object)rtn);
        }
        CableNetworkManager.onNetworkLookupChanged();
        return Optional.of(rtn);
    }

    public static List<BlockPos> getBadCableCachePositions(Level level) {
        return CableNetworkManager.getNetworksForLevel(level).flatMap(CableNetwork::getCablePositions).filter(pos -> !(level.getBlockState(pos).getBlock() instanceof ICableBlock)).collect(Collectors.toList());
    }

    public static void clear() {
        NETWORKS_BY_LEVEL.clear();
        NETWORKS_BY_CABLE_POSITION.clear();
        CableNetworkManager.onNetworkLookupChanged();
    }

    private static Optional<CableNetwork> getNetworkFromCablePosition(Level level, @NotStored BlockPos pos) {
        return Optional.ofNullable((CableNetwork)NETWORKS_BY_CABLE_POSITION.computeIfAbsent(level, k -> new Long2ObjectOpenHashMap()).get(pos.asLong()));
    }

    private static void removeNetwork(CableNetwork network) {
        NETWORKS_BY_LEVEL.getOrDefault(network.getLevel(), Collections.emptyList()).remove(network);
        Long2ObjectMap posMap = NETWORKS_BY_CABLE_POSITION.computeIfAbsent(network.getLevel(), k -> new Long2ObjectOpenHashMap());
        network.cablePositions.forEach(arg_0 -> ((Long2ObjectMap)posMap).remove(arg_0));
        CableNetworkManager.onNetworkLookupChanged();
    }

    private static void addNetwork(CableNetwork network) {
        NETWORKS_BY_LEVEL.computeIfAbsent(network.getLevel(), k -> new ArrayList()).add(network);
        Long2ObjectMap posMap = NETWORKS_BY_CABLE_POSITION.computeIfAbsent(network.getLevel(), k -> new Long2ObjectOpenHashMap());
        network.cablePositions.forEach(cablePos -> posMap.put(cablePos, (Object)network));
        CableNetworkManager.onNetworkLookupChanged();
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        ChunkAccess chunk = event.getChunk();
        CableNetworkManager.purgeChunkFromCableNetworks(level, chunk);
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        NETWORKS_BY_LEVEL.remove(level);
        NETWORKS_BY_CABLE_POSITION.remove(level);
    }

    public static void purgeChunkFromCableNetworks(ServerLevel level, ChunkAccess chunkAccess) {
        CableNetworkManager.getNetworksForLevel((Level)level).forEach(network -> network.bustCacheForChunk(chunkAccess));
    }
}

