/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.SFMDirections;
import ca.teamdman.sfm.common.util.Stored;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;

public class SFMStreamUtils {
    public static <T, R> Stream<R> getRecursiveStream(RecursiveBuilder<T, R> operator, T first) {
        HashSet<T> visitDebounce = new HashSet<T>();
        ArrayDeque<T> toVisit = new ArrayDeque<T>();
        toVisit.add(first);
        visitDebounce.add(first);
        return SFMStreamUtils.getRecursiveStream(operator, visitDebounce, toVisit);
    }

    public static <T, R> Stream<R> getRecursiveStream(RecursiveBuilder<T, R> operator, Set<T> visitDebounce, Deque<T> toVisit) {
        Stream.Builder builder = Stream.builder();
        while (!toVisit.isEmpty()) {
            T current = toVisit.pop();
            operator.accept(current, next -> {
                if (!visitDebounce.contains(next)) {
                    visitDebounce.add(next);
                    toVisit.add(next);
                }
            }, builder::add);
        }
        return builder.build();
    }

    public static Stream<BlockPos> get3DNeighboursIncludingKittyCorner(@NotStored BlockPos pos) {
        Stream.Builder<BlockPos> builder = Stream.builder();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    builder.accept(pos.offset(x, y, z).immutable());
                }
            }
        }
        return builder.build();
    }

    public static Stream<BlockPos> get3DNeighbours(@Stored BlockPos pos) {
        return Arrays.stream(SFMDirections.DIRECTIONS_WITHOUT_NULL).map(d -> pos.offset(d.getNormal()));
    }

    public static <T> Iterable<T> iterate(Stream<T> stream) {
        return stream::iterator;
    }

    public static interface RecursiveBuilder<T, R> {
        public void accept(T var1, Consumer<T> var2, Consumer<R> var3);
    }
}

