/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfml.ast.ASTNode;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public enum Side implements ASTNode
{
    TOP,
    BOTTOM,
    NORTH,
    SOUTH,
    EAST,
    WEST,
    LEFT,
    RIGHT,
    FRONT,
    BACK,
    NULL;


    public static Side fromDirection(@Nullable Direction direction) {
        if (direction == null) {
            return NULL;
        }
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> TOP;
            case Direction.DOWN -> BOTTOM;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
        };
    }

    @Nullable
    public Direction resolve(BlockState blockState) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Direction.UP;
            case 1 -> Direction.DOWN;
            case 2 -> Direction.NORTH;
            case 3 -> Direction.SOUTH;
            case 4 -> Direction.EAST;
            case 5 -> Direction.WEST;
            case 6 -> blockState.getOptionalValue((Property)BlockStateProperties.HORIZONTAL_FACING).or(() -> blockState.getOptionalValue((Property)BlockStateProperties.FACING)).map(Direction::getClockWise).orElse(null);
            case 7 -> blockState.getOptionalValue((Property)BlockStateProperties.HORIZONTAL_FACING).or(() -> blockState.getOptionalValue((Property)BlockStateProperties.FACING)).map(Direction::getCounterClockWise).orElse(null);
            case 8 -> blockState.getOptionalValue((Property)BlockStateProperties.HORIZONTAL_FACING).or(() -> blockState.getOptionalValue((Property)BlockStateProperties.FACING)).orElse(null);
            case 9 -> blockState.getOptionalValue((Property)BlockStateProperties.HORIZONTAL_FACING).or(() -> blockState.getOptionalValue((Property)BlockStateProperties.FACING)).map(Direction::getOpposite).orElse(null);
            case 10 -> null;
        };
    }
}

