/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.screen;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.ClientTranslationHelpers;
import ca.teamdman.sfm.client.ProgramSyntaxHighlightingHelper;
import ca.teamdman.sfm.client.screen.SFMFontUtils;
import ca.teamdman.sfm.client.screen.SFMScreenRenderUtils;
import ca.teamdman.sfm.client.screen.text_editor.SFMTextEditScreenV1;
import ca.teamdman.sfm.client.widget.SFMButtonBuilder;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.diagnostics.SFMDiagnostics;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.logging.TranslatableLogEvent;
import ca.teamdman.sfm.common.net.ServerboundManagerClearLogsPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerLogDesireUpdatePacket;
import ca.teamdman.sfm.common.net.ServerboundManagerSetLogLevelPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.core.time.MutableInstant;
import org.joml.Matrix4f;

public class LogsScreen
extends Screen {
    private final ManagerContainerMenu MENU;
    private MyMultiLineEditBox textarea;
    private List<MutableComponent> content = Collections.emptyList();
    private int lastSize = 0;
    private Map<Level, Button> levelButtons = new HashMap<Level, Button>();
    private String lastKnownLogLevel;

    public LogsScreen(ManagerContainerMenu menu) {
        super((Component)LocalizationKeys.LOGS_SCREEN_TITLE.getComponent());
        this.MENU = menu;
        this.lastKnownLogLevel = this.MENU.logLevel;
    }

    public boolean isPauseScreen() {
        return false;
    }

    private boolean shouldRebuildText() {
        return this.MENU.logs.size() != this.lastSize;
    }

    private void rebuildText() {
        ArrayList<MutableComponent> processedLogs = new ArrayList<MutableComponent>();
        ArrayDeque<TranslatableLogEvent> toProcess = this.MENU.logs;
        if (toProcess.isEmpty() && this.MENU.logLevel.equals(Level.OFF.name())) {
            MutableInstant instant = new MutableInstant();
            instant.initFromEpochMilli(System.currentTimeMillis(), 0);
            toProcess.add(new TranslatableLogEvent(Level.INFO, (Instant)instant, LocalizationKeys.LOGS_GUI_NO_CONTENT.get()));
        }
        for (TranslatableLogEvent log : toProcess) {
            int seconds = (int)(System.currentTimeMillis() - log.instant().getEpochMillisecond()) / 1000;
            int minutes = seconds / 60;
            MutableComponent ago = Component.literal((String)(minutes + "m" + (seconds %= 60) + "s ago")).withStyle(ChatFormatting.GRAY);
            MutableComponent level = Component.literal((String)(" [" + log.level() + "] "));
            if (log.level() == Level.ERROR) {
                level = level.withStyle(ChatFormatting.RED);
            } else if (log.level() == Level.WARN) {
                level = level.withStyle(ChatFormatting.YELLOW);
            } else if (log.level() == Level.INFO) {
                level = level.withStyle(ChatFormatting.GREEN);
            } else if (log.level() == Level.DEBUG) {
                level = level.withStyle(ChatFormatting.AQUA);
            } else if (log.level() == Level.TRACE) {
                level = level.withStyle(ChatFormatting.DARK_GRAY);
            }
            String[] lines = ClientTranslationHelpers.resolveTranslation(log.contents()).split("\n", -1);
            StringBuilder codeBlock = new StringBuilder();
            boolean insideCodeBlock = false;
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (line.equals("```")) {
                    if (insideCodeBlock) {
                        List<MutableComponent> codeLines = ProgramSyntaxHighlightingHelper.withSyntaxHighlighting(codeBlock.toString(), false);
                        processedLogs.addAll(codeLines);
                        codeBlock = new StringBuilder();
                        continue;
                    }
                    insideCodeBlock = true;
                    continue;
                }
                if (insideCodeBlock) {
                    codeBlock.append(line).append("\n");
                    continue;
                }
                MutableComponent lineComponent = Component.literal((String)line).withStyle(ChatFormatting.WHITE);
                if (i == 0) {
                    lineComponent = ago.append((Component)level).append((Component)lineComponent);
                }
                processedLogs.add(lineComponent);
            }
        }
        this.content = processedLogs;
        StringBuilder sb = new StringBuilder();
        for (MutableComponent line : this.content) {
            sb.append(line.getString()).append("\n");
        }
        this.textarea.setValue(sb.toString());
        this.lastSize = this.MENU.logs.size();
    }

    public boolean isReadOnly() {
        LocalPlayer player = Minecraft.getInstance().player;
        return player == null || player.isSpectator();
    }

    public void onLogLevelChange() {
        for (Map.Entry<Level, Button> entry : this.levelButtons.entrySet()) {
            Level level = entry.getKey();
            Button button = entry.getValue();
            button.active = !this.MENU.logLevel.equals(level.name());
        }
        this.lastKnownLogLevel = this.MENU.logLevel;
    }

    protected void init() {
        Level[] levelArray;
        super.init();
        assert (this.minecraft != null);
        this.textarea = (MyMultiLineEditBox)this.addRenderableWidget((GuiEventListener)new MyMultiLineEditBox());
        this.rebuildText();
        this.setInitialFocus((GuiEventListener)this.textarea);
        if (this.isReadOnly()) {
            levelArray = new Level[]{};
        } else {
            Level[] levelArray2 = new Level[6];
            levelArray2[0] = Level.OFF;
            levelArray2[1] = Level.TRACE;
            levelArray2[2] = Level.DEBUG;
            levelArray2[3] = Level.INFO;
            levelArray2[4] = Level.WARN;
            levelArray = levelArray2;
            levelArray2[5] = Level.ERROR;
        }
        Level[] buttons = levelArray;
        int buttonWidth = 60;
        int buttonHeight = 20;
        int spacing = 5;
        int startX = (this.width - (buttonWidth * buttons.length + spacing * 4)) / 2;
        int startY = this.height / 2 - 115;
        int buttonIndex = 0;
        this.levelButtons = new HashMap<Level, Button>();
        for (Level level : buttons) {
            Button levelButton = new SFMButtonBuilder().setSize(buttonWidth, buttonHeight).setPosition(startX + (buttonWidth + spacing) * buttonIndex, startY).setText((Component)Component.literal((String)level.name())).setOnPress(button -> {
                String logLevel = level.name();
                SFMPackets.sendToServer(new ServerboundManagerSetLogLevelPacket(this.MENU.containerId, this.MENU.MANAGER_POSITION, logLevel));
                this.MENU.logLevel = logLevel;
                this.onLogLevelChange();
            }).build();
            this.levelButtons.put(level, levelButton);
            this.addRenderableWidget((GuiEventListener)levelButton);
            ++buttonIndex;
        }
        this.onLogLevelChange();
        this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition(this.width / 2 - 200, this.height / 2 - 100 + 195).setSize(80, 20).setText(LocalizationKeys.LOGS_GUI_COPY_LOGS_BUTTON).setOnPress(this::onCopyLogsClicked).setTooltip((Screen)this, this.font, LocalizationKeys.LOGS_GUI_COPY_LOGS_BUTTON_TOOLTIP).build());
        this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition(this.width / 2 - 2 - 100, this.height / 2 - 100 + 195).setSize(200, 20).setText(CommonComponents.GUI_DONE).setOnPress(p_97691_ -> this.onClose()).setTooltip((Screen)this, this.font, LocalizationKeys.PROGRAM_EDIT_SCREEN_DONE_BUTTON_TOOLTIP).build());
        if (!this.isReadOnly()) {
            this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition(this.width / 2 - 2 + 115, this.height / 2 - 100 + 195).setSize(80, 20).setText(LocalizationKeys.LOGS_GUI_CLEAR_LOGS_BUTTON).setOnPress(button -> {
                SFMPackets.sendToServer(new ServerboundManagerClearLogsPacket(this.MENU.containerId, this.MENU.MANAGER_POSITION));
                this.MENU.logs.clear();
            }).build());
        }
    }

    private void onCopyLogsClicked(Button button) {
        StringBuilder clip = new StringBuilder();
        clip.append(SFMDiagnostics.getDiagnosticsSummary(this.MENU.getDisk()));
        clip.append("\n-- LOGS --\n");
        if (LogsScreen.hasShiftDown()) {
            for (TranslatableLogEvent log : this.MENU.logs) {
                clip.append(log.level().name()).append(" ");
                clip.append(log.instant().toString()).append(" ");
                clip.append(log.contents().getKey());
                for (Object arg : log.contents().getArgs()) {
                    clip.append(" ").append(arg);
                }
                clip.append("\n");
            }
        } else {
            for (MutableComponent line : this.content) {
                clip.append(line.getString()).append("\n");
            }
        }
        Minecraft.getInstance().keyboardHandler.setClipboard(clip.toString());
    }

    public void onClose() {
        SFMPackets.sendToServer(new ServerboundManagerLogDesireUpdatePacket(this.MENU.containerId, this.MENU.MANAGER_POSITION, false));
        super.onClose();
    }

    public void scrollToBottom() {
        this.textarea.scrollToBottom();
    }

    public void resize(Minecraft mc, int x, int y) {
        String prev = this.textarea.getValue();
        this.init(mc, x, y);
        super.resize(mc, x, y);
        this.textarea.setValue(prev);
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderTransparentBackground(pGuiGraphics);
        super.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        if (!this.MENU.logLevel.equals(this.lastKnownLogLevel)) {
            this.onLogLevelChange();
        }
    }

    private class MyMultiLineEditBox
    extends MultiLineEditBox {
        private int frame;

        public MyMultiLineEditBox() {
            super(LogsScreen.this.font, LogsScreen.this.width / 2 - 200, LogsScreen.this.height / 2 - 90, 400, 180, (Component)Component.literal((String)""), (Component)Component.literal((String)""));
            this.frame = 0;
        }

        public void scrollToBottom() {
            this.setScrollAmount(Double.MAX_VALUE);
        }

        public void setValue(String p_240160_) {
            this.textField.setValue(p_240160_);
        }

        public boolean mouseClicked(double p_239101_, double p_239102_, int p_239103_) {
            try {
                return super.mouseClicked(p_239101_, p_239102_, p_239103_);
            }
            catch (Exception e) {
                SFM.LOGGER.error("Error in LogsScreen.MyMultiLineEditBox.mouseClicked", (Throwable)e);
                return false;
            }
        }

        public int getInnerHeight() {
            Objects.requireNonNull(this.font);
            return 9 * (LogsScreen.this.content.size() + 2);
        }

        protected void renderContents(GuiGraphics pGuiGraphics, int mx, int my, float partialTicks) {
            PoseStack poseStack = pGuiGraphics.pose();
            Matrix4f matrix4f = poseStack.last().pose();
            if (LogsScreen.this.shouldRebuildText()) {
                LogsScreen.this.rebuildText();
            }
            boolean isCursorVisible = this.isFocused() && this.frame++ / 60 % 2 == 0;
            boolean isCursorAtEndOfLine = false;
            int cursorIndex = this.textField.cursor();
            int lineX = SFMScreenRenderUtils.getX((AbstractWidget)this) + this.innerPadding();
            int lineY = SFMScreenRenderUtils.getY((AbstractWidget)this) + this.innerPadding();
            int charCount = 0;
            int cursorX = 0;
            int cursorY = 0;
            MultilineTextField.StringView selectedRange = this.textField.getSelected();
            int selectionStart = selectedRange.beginIndex();
            int selectionEnd = selectedRange.endIndex();
            for (int line = Math.max(0, LogsScreen.this.content.size() - 500); line < LogsScreen.this.content.size(); ++line) {
                MutableComponent componentColoured = LogsScreen.this.content.get(line);
                int lineLength = componentColoured.getString().length();
                Objects.requireNonNull(this.font);
                int lineHeight = 9 + (line == 0 ? 2 : 0);
                boolean cursorOnThisLine = isCursorVisible && cursorIndex >= charCount && cursorIndex <= charCount + lineLength;
                MultiBufferSource.BufferSource buffer = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
                if (cursorOnThisLine) {
                    isCursorAtEndOfLine = cursorIndex == charCount + lineLength;
                    cursorY = lineY;
                    cursorX = SFMFontUtils.drawInBatch((Component)SFMTextEditScreenV1.substring(componentColoured, 0, cursorIndex - charCount), this.font, (float)lineX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer) - 1;
                    SFMFontUtils.drawInBatch((Component)SFMTextEditScreenV1.substring(componentColoured, cursorIndex - charCount, lineLength), this.font, (float)cursorX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                } else {
                    SFMFontUtils.drawInBatch((Component)componentColoured, this.font, (float)lineX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                }
                buffer.endBatch();
                if (selectionStart <= charCount + lineLength && selectionEnd > charCount) {
                    int lineSelectionStart = Math.max(selectionStart - charCount, 0);
                    int lineSelectionEnd = Math.min(selectionEnd - charCount, lineLength);
                    int highlightStartX = this.font.width((FormattedText)SFMTextEditScreenV1.substring(componentColoured, 0, lineSelectionStart));
                    int highlightEndX = this.font.width((FormattedText)SFMTextEditScreenV1.substring(componentColoured, 0, lineSelectionEnd));
                    SFMScreenRenderUtils.renderHighlight(pGuiGraphics, lineX + highlightStartX, lineY, lineX + highlightEndX, lineY + lineHeight);
                }
                lineY += lineHeight;
                charCount += lineLength + 1;
            }
            if (isCursorAtEndOfLine) {
                SFMFontUtils.draw(pGuiGraphics, this.font, "_", cursorX, cursorY, -1, true);
            } else {
                pGuiGraphics.fill(cursorX, cursorY - 1, cursorX + 1, cursorY + 1 + 9, -1);
            }
        }
    }
}

