/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.widget;

import ca.teamdman.sfm.client.screen.SFMFontUtils;
import ca.teamdman.sfm.client.screen.SFMScreenRenderUtils;
import ca.teamdman.sfm.client.widget.PickListItem;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractScrollWidget;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.simmetrics.StringDistance;
import org.simmetrics.builders.StringDistanceBuilder;
import org.simmetrics.metrics.StringDistances;
import org.simmetrics.simplifiers.Simplifiers;

public class PickList<T extends PickListItem>
extends AbstractScrollWidget {
    protected final Font font;
    protected List<T> items;
    protected int selectionIndex = -1;
    protected Component query = Component.empty();

    public PickList(Font font, int pX, int pY, int pWidth, int pHeight, Component title, List<T> items) {
        super(pX, pY, pWidth, pHeight, title);
        this.font = font;
        this.items = items;
        this.clampOrUnsetSelectionIndex();
    }

    public List<T> getItems() {
        return this.items;
    }

    public void setItems(List<T> items) {
        this.items = items;
        this.sortItems();
        this.selectionIndex = 0;
        this.clampOrUnsetSelectionIndex();
        this.scrollSelectedIntoView();
    }

    public int getItemHeight() {
        Objects.requireNonNull(this.font);
        return 9;
    }

    @Nullable
    public T getSelected() {
        if (this.items.isEmpty()) {
            return null;
        }
        if (this.selectionIndex < 0) {
            return null;
        }
        if (this.selectionIndex >= this.items.size()) {
            return null;
        }
        return (T)((PickListItem)this.getItems().get(this.selectionIndex));
    }

    public void setQuery(Component query) {
        this.query = query;
        this.sortItems();
        this.selectionIndex = 0;
        this.clampOrUnsetSelectionIndex();
        this.scrollSelectedIntoView();
    }

    @MCVersionDependentBehaviour
    public void setXY(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    @MCVersionDependentBehaviour
    protected void updateWidgetNarration(NarrationElementOutput narration) {
        narration.add(NarratedElementType.TITLE, this.getMessage());
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.items.isEmpty()) {
            return;
        }
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
    }

    public void selectPreviousWrapping() {
        if (this.selectionIndex == -1) {
            this.selectionIndex = this.items.size() - 1;
            return;
        }
        this.selectionIndex = (this.selectionIndex - 1 + this.items.size()) % this.items.size();
        this.scrollSelectedIntoView();
    }

    public void selectNextWrapping() {
        if (this.selectionIndex == -1) {
            this.selectionIndex = 0;
            return;
        }
        this.selectionIndex = (this.selectionIndex + 1) % this.items.size();
        this.scrollSelectedIntoView();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public void clear() {
        this.items.clear();
        this.selectionIndex = -1;
    }

    private void clampOrUnsetSelectionIndex() {
        this.selectionIndex = this.items.isEmpty() ? -1 : Mth.clamp((int)this.selectionIndex, (int)0, (int)(this.items.size() - 1));
    }

    private void scrollSelectedIntoView() {
        if (this.isEmpty()) {
            this.setScrollAmount(0.0);
        } else {
            this.setScrollAmount((float)(this.selectionIndex * this.getItemHeight()) - (float)this.height / 2.0f + (float)this.getItemHeight());
        }
    }

    private void sortItems() {
        StringDistance distance = StringDistanceBuilder.with(StringDistances.jaroWinkler()).simplify(Simplifiers.toLowerCase()).build();
        String queryString = this.query.getString();
        if (queryString.isBlank()) {
            String[] preferredOrder = new String[]{"TICKS", "INPUT", "OUTPUT", "FORGET", "FROM", "TO"};
            this.items.sort(Comparator.comparing(item -> {
                String itemString = item.getComponent().getString();
                for (int i = 0; i < preferredOrder.length; ++i) {
                    if (!itemString.contains(preferredOrder[i])) continue;
                    return i;
                }
                return preferredOrder.length;
            }));
        } else {
            this.items.sort(Comparator.comparing(item -> Float.valueOf(distance.distance(item.getComponent().getString(), queryString))));
        }
    }

    protected int getInnerHeight() {
        return this.getItemHeight() * this.items.size();
    }

    protected boolean scrollbarVisible() {
        return (double)this.items.size() > this.getDisplayableItemCount();
    }

    private double getDisplayableItemCount() {
        return (double)(this.height - this.totalInnerPadding()) / (double)this.getItemHeight();
    }

    protected double scrollRate() {
        return (double)this.getItemHeight() / 2.0;
    }

    protected void renderContents(GuiGraphics graphics, int mx, int my, float partialTick) {
        if (this.items.isEmpty()) {
            return;
        }
        int itemHeight = this.getItemHeight();
        int startIndex = (int)(this.scrollAmount() / (double)itemHeight);
        int visibleCount = (int)Math.ceil((double)this.height / (double)itemHeight) + 1;
        int endIndex = Math.min(this.items.size(), startIndex + visibleCount);
        Matrix4f matrix4f = graphics.pose().last().pose();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
        int lineX = SFMScreenRenderUtils.getX((AbstractWidget)this) + this.innerPadding();
        Rect2i highlight = null;
        for (int i = startIndex; i < endIndex; ++i) {
            PickListItem item = (PickListItem)this.items.get(i);
            int lineY = SFMScreenRenderUtils.getY((AbstractWidget)this) + this.innerPadding() + i * itemHeight;
            SFMFontUtils.drawInBatch(item.getComponent(), this.font, (float)lineX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
            if (i != this.selectionIndex) continue;
            highlight = new Rect2i(lineX, lineY, this.width, itemHeight);
        }
        buffer.endBatch();
        if (highlight != null) {
            SFMScreenRenderUtils.renderHighlight(graphics, highlight.getX(), highlight.getY(), highlight.getX() + highlight.getWidth(), highlight.getY() + highlight.getHeight());
        }
    }
}

