/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.capabilityprovidermapper;

import ca.teamdman.sfm.common.capabilityprovidermapper.CapabilityProviderMapper;
import ca.teamdman.sfm.common.util.Stored;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.capabilities.Capabilities;
import net.neoforged.neoforge.common.capabilities.Capability;
import net.neoforged.neoforge.common.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.common.util.LazyOptional;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CauldronCapabilityProviderMapper
implements CapabilityProviderMapper {
    @Override
    @Nullable
    public ICapabilityProvider getProviderFor(LevelAccessor level, @Stored BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() == Blocks.CAULDRON || state.getBlock() == Blocks.WATER_CAULDRON || state.getBlock() == Blocks.LAVA_CAULDRON) {
            return new CauldronCapabilityProvider(level, pos);
        }
        return null;
    }

    private static class CauldronCapabilityProvider
    implements ICapabilityProvider {
        private final LazyOptional<IFluidHandler> fluidHandlerLazyOptional = LazyOptional.of(() -> new CauldronFluidHandler(level, pos));

        public CauldronCapabilityProvider(LevelAccessor level, BlockPos pos) {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == Capabilities.FLUID_HANDLER) {
                return this.fluidHandlerLazyOptional.cast();
            }
            return LazyOptional.empty();
        }
    }

    private record CauldronFluidHandler(LevelAccessor level, BlockPos pos) implements IFluidHandler
    {
        public int getTanks() {
            return 1;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            BlockState state = this.level.getBlockState(this.pos);
            if (state.getBlock() == Blocks.WATER_CAULDRON) {
                int level = (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL);
                if (level == 0) {
                    return FluidStack.EMPTY;
                }
                return new FluidStack((Fluid)Fluids.WATER, level * 250);
            }
            if (state.getBlock() == Blocks.LAVA_CAULDRON) {
                return new FluidStack((Fluid)Fluids.LAVA, 1000);
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return 1000;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            return stack.getFluid() == Fluids.WATER || stack.getFluid() == Fluids.LAVA;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            BlockState state = this.level.getBlockState(this.pos);
            if (state.getBlock() == Blocks.CAULDRON) {
                if (resource.getFluid() == Fluids.WATER) {
                    int layers = Math.min(3, resource.getAmount() / 250);
                    if (action.execute()) {
                        this.level.setBlock(this.pos, (BlockState)Blocks.WATER_CAULDRON.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(layers)), 3);
                    }
                    return layers * 250;
                }
                if (resource.getFluid() == Fluids.LAVA && resource.getAmount() >= 1000) {
                    if (action.execute()) {
                        this.level.setBlock(this.pos, Blocks.LAVA_CAULDRON.defaultBlockState(), 3);
                    }
                    return 1000;
                }
            } else if (state.getBlock() instanceof LayeredCauldronBlock) {
                int waterLevel = (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL);
                if (waterLevel >= 3) {
                    return 0;
                }
                int waterLevelIncrease = Math.min(3 - waterLevel, Math.min(3, resource.getAmount() / 250));
                if (action.execute()) {
                    this.level.setBlock(this.pos, (BlockState)state.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(waterLevel + waterLevelIncrease)), 3);
                }
                return waterLevelIncrease * 250;
            }
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            BlockState state = this.level.getBlockState(this.pos);
            if (state.getBlock() instanceof LayeredCauldronBlock) {
                int waterLevel = (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL);
                if (waterLevel == 0) {
                    return FluidStack.EMPTY;
                }
                int waterLevelDrain = Math.min(waterLevel, resource.getAmount() / 250);
                if (action.execute()) {
                    int resultLevel = waterLevel - waterLevelDrain;
                    if (resultLevel == 0) {
                        this.level.setBlock(this.pos, Blocks.CAULDRON.defaultBlockState(), 3);
                    } else {
                        this.level.setBlock(this.pos, (BlockState)state.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(resultLevel)), 3);
                    }
                }
                return new FluidStack((Fluid)Fluids.WATER, waterLevelDrain * 250);
            }
            if (state.getBlock() == Blocks.LAVA_CAULDRON && resource.getAmount() >= 1000) {
                if (action.execute()) {
                    this.level.setBlock(this.pos, Blocks.CAULDRON.defaultBlockState(), 3);
                }
                return new FluidStack((Fluid)Fluids.LAVA, 1000);
            }
            return FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            BlockState state = this.level.getBlockState(this.pos);
            if (state.getBlock() instanceof LayeredCauldronBlock) {
                int waterLevel = (Integer)state.getValue((Property)LayeredCauldronBlock.LEVEL);
                if (waterLevel == 0) {
                    return FluidStack.EMPTY;
                }
                int waterLevelDrain = Math.min(waterLevel, maxDrain / 250);
                if (action.execute()) {
                    this.level.setBlock(this.pos, (BlockState)state.setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)Integer.valueOf(waterLevel - waterLevelDrain)), 3);
                }
                return new FluidStack((Fluid)Fluids.WATER, waterLevelDrain * 250);
            }
            if (state.getBlock() == Blocks.LAVA_CAULDRON && maxDrain >= 1000) {
                if (action.execute()) {
                    this.level.setBlock(this.pos, Blocks.CAULDRON.defaultBlockState(), 3);
                }
                return new FluidStack((Fluid)Fluids.LAVA, 1000);
            }
            return FluidStack.EMPTY;
        }
    }
}

