/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.common.item.LabelGunItem;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.net.SFMPacketDaddy;
import ca.teamdman.sfm.common.net.SFMPacketHandlingContext;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;

public record ServerboundLabelGunSetActiveLabelPacket(String label, InteractionHand hand) implements SFMPacket
{
    public static final int MAX_LABEL_LENGTH = 256;

    public static class Daddy
    implements SFMPacketDaddy<ServerboundLabelGunSetActiveLabelPacket> {
        @Override
        public SFMPacketDaddy.PacketDirection getPacketDirection() {
            return SFMPacketDaddy.PacketDirection.SERVERBOUND;
        }

        @Override
        public void encode(ServerboundLabelGunSetActiveLabelPacket msg, FriendlyByteBuf buf) {
            buf.writeUtf(msg.label, 256);
            buf.writeEnum((Enum)msg.hand);
        }

        @Override
        public ServerboundLabelGunSetActiveLabelPacket decode(FriendlyByteBuf buf) {
            return new ServerboundLabelGunSetActiveLabelPacket(buf.readUtf(256), (InteractionHand)buf.readEnum(InteractionHand.class));
        }

        @Override
        public void handle(ServerboundLabelGunSetActiveLabelPacket msg, SFMPacketHandlingContext context) {
            ServerPlayer sender = context.sender();
            if (sender == null) {
                return;
            }
            ItemStack stack = sender.getItemInHand(msg.hand);
            if (stack.getItem() instanceof LabelGunItem) {
                LabelGunItem.setActiveLabel(stack, msg.label);
            }
        }

        @Override
        public Class<ServerboundLabelGunSetActiveLabelPacket> getPacketClass() {
            return ServerboundLabelGunSetActiveLabelPacket.class;
        }
    }
}

