/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.registry;

import ca.teamdman.sfm.common.capabilityprovidermapper.BlockEntityCapabilityProviderMapper;
import ca.teamdman.sfm.common.capabilityprovidermapper.CapabilityProviderMapper;
import ca.teamdman.sfm.common.capabilityprovidermapper.CauldronCapabilityProviderMapper;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import ca.teamdman.sfm.common.util.Stored;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.common.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public class SFMCapabilityProviderMappers {
    public static final ResourceKey<Registry<CapabilityProviderMapper>> REGISTRY_ID = ResourceKey.createRegistryKey((ResourceLocation)new ResourceLocation("sfm", "capability_provider_mappers"));
    private static final DeferredRegister<CapabilityProviderMapper> REGISTERER = DeferredRegister.create(REGISTRY_ID, (String)"sfm");
    public static final Registry<CapabilityProviderMapper> REGISTRY = REGISTERER.makeRegistry(registryBuilder -> {});
    public static final Supplier<BlockEntityCapabilityProviderMapper> BLOCK_ENTITY_MAPPER = REGISTERER.register("block_entity", BlockEntityCapabilityProviderMapper::new);
    public static final Supplier<CauldronCapabilityProviderMapper> CAULDRON_MAPPER = REGISTERER.register("cauldron", CauldronCapabilityProviderMapper::new);

    public static void register(IEventBus bus) {
        REGISTERER.register(bus);
    }

    @MCVersionDependentBehaviour
    public static Registry<CapabilityProviderMapper> registry() {
        return REGISTRY;
    }

    @Nullable
    public static ICapabilityProvider discoverCapabilityProvider(Level level, @Stored BlockPos pos) {
        if (!level.isLoaded(pos)) {
            return null;
        }
        Set mappers = REGISTRY.entrySet();
        CapabilityProviderMapper beMapper = null;
        for (Map.Entry entry : mappers) {
            CapabilityProviderMapper mapper = (CapabilityProviderMapper)entry.getValue();
            if (mapper instanceof BlockEntityCapabilityProviderMapper) {
                beMapper = mapper;
                continue;
            }
            ICapabilityProvider capabilityProvider = mapper.getProviderFor((LevelAccessor)level, pos);
            if (capabilityProvider == null) continue;
            return capabilityProvider;
        }
        return beMapper != null ? beMapper.getProviderFor((LevelAccessor)level, pos) : null;
    }
}

