/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.resourcetype;

import ca.teamdman.sfm.common.resourcetype.ResourceType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.capabilities.Capability;
import org.jetbrains.annotations.Nullable;

public abstract class ScalarResourceType<STACK, CAP>
extends ResourceType<STACK, Class<STACK>, CAP> {
    public final ResourceLocation registryKey;
    public final Class<STACK> item;

    public ScalarResourceType(Capability<CAP> capability, ResourceLocation registryKey, Class<STACK> item) {
        super(capability);
        this.registryKey = registryKey;
        this.item = item;
    }

    @Override
    public ResourceLocation getRegistryKeyForStack(STACK stack) {
        return this.registryKey;
    }

    @Override
    public ResourceLocation getRegistryKeyForItem(Class<STACK> item) {
        return this.registryKey;
    }

    @Override
    @Nullable
    public Class<STACK> getItemFromRegistryKey(ResourceLocation location) {
        if (location.equals((Object)this.registryKey)) {
            return this.item;
        }
        return null;
    }

    @Override
    public Set<ResourceLocation> getRegistryKeys() {
        return Set.of(this.registryKey);
    }

    @Override
    public Collection<Class<STACK>> getItems() {
        return List.of(this.item);
    }

    @Override
    public boolean registryKeyExists(ResourceLocation location) {
        return location.equals((Object)this.registryKey);
    }

    @Override
    public Class<STACK> getItem(STACK stack) {
        return this.item;
    }

    @Override
    public boolean matchesStackType(Object o) {
        return this.item.isInstance(o);
    }
}

