/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Label;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;

public class RoundRobin
implements ASTNode {
    private final Behaviour behaviour;
    private int nextIndex = 0;

    public RoundRobin(Behaviour behaviour) {
        this.behaviour = behaviour;
    }

    public static RoundRobin disabled() {
        return new RoundRobin(Behaviour.UNMODIFIED);
    }

    public Behaviour getBehaviour() {
        return this.behaviour;
    }

    public int next(int length) {
        return this.nextIndex++ % length;
    }

    public String toString() {
        return switch (this.behaviour) {
            default -> throw new IncompatibleClassChangeError();
            case Behaviour.UNMODIFIED -> "NOT ROUND ROBIN";
            case Behaviour.BY_BLOCK -> "ROUND ROBIN BY BLOCK";
            case Behaviour.BY_LABEL -> "ROUND ROBIN BY LABEL";
        };
    }

    public boolean isEnabled() {
        return this.behaviour != Behaviour.UNMODIFIED;
    }

    public ArrayList<Pair<Label, BlockPos>> getPositionsForLabels(List<Label> labels, LabelPositionHolder labelPositionHolder) {
        ArrayList<Pair<Label, BlockPos>> positions = new ArrayList<Pair<Label, BlockPos>>();
        switch (this.getBehaviour()) {
            case BY_LABEL: {
                int index = this.next(labels.size());
                Label label = labels.get(index);
                Set<BlockPos> labelPositions = labelPositionHolder.getPositions(label.name());
                positions.ensureCapacity(labelPositions.size());
                for (BlockPos pos : labelPositions) {
                    positions.add((Pair<Label, BlockPos>)Pair.of((Object)label, (Object)pos));
                }
                break;
            }
            case BY_BLOCK: {
                ArrayList<Pair> candidates = new ArrayList<Pair>();
                LongOpenHashSet seen = new LongOpenHashSet();
                for (Label label : labels) {
                    for (BlockPos pos : labelPositionHolder.getPositions(label.name())) {
                        if (!seen.add(pos.asLong())) continue;
                        candidates.add(Pair.of((Object)label, (Object)pos));
                    }
                }
                if (candidates.isEmpty()) break;
                positions.add((Pair<Label, BlockPos>)((Pair)candidates.get(this.next(candidates.size()))));
                break;
            }
            case UNMODIFIED: {
                for (Label label : labels) {
                    Set<BlockPos> labelPositions = labelPositionHolder.getPositions(label.name());
                    positions.ensureCapacity(labelPositions.size());
                    for (BlockPos pos : labelPositions) {
                        positions.add((Pair<Label, BlockPos>)Pair.of((Object)label, (Object)pos));
                    }
                }
                break;
            }
        }
        return positions;
    }

    public static enum Behaviour {
        UNMODIFIED,
        BY_BLOCK,
        BY_LABEL;

    }
}

