/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.facade;

import ca.teamdman.sfm.common.facade.FacadeTextureMode;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public record FacadeData(BlockState facadeBlockState, Direction facadeDirection, FacadeTextureMode facadeTextureMode) {
    public void save(CompoundTag tag) {
        CompoundTag facadeTag = new CompoundTag();
        facadeTag.m_128365_("block_state", (Tag)NbtUtils.m_129202_((BlockState)this.facadeBlockState()));
        facadeTag.m_128359_("direction", this.facadeDirection().m_7912_());
        facadeTag.m_128359_("texture_mode", this.facadeTextureMode().m_7912_());
        tag.m_128365_("sfm:facade", (Tag)facadeTag);
    }

    @Nullable
    public static FacadeData load(@Nullable Level level, CompoundTag tag) {
        if (tag.m_128425_("sfm:facade", 10)) {
            CompoundTag facadeTag = tag.m_128469_("sfm:facade");
            BlockState facadeState = FacadeData.readBlockState(facadeTag.m_128469_("block_state"), level);
            Direction facadeDirection = Direction.m_122402_((String)facadeTag.m_128461_("direction"));
            FacadeTextureMode facadeTextureMode = FacadeTextureMode.byName(facadeTag.m_128461_("texture_mode"));
            if (facadeTextureMode != null && facadeDirection != null) {
                return new FacadeData(facadeState, facadeDirection, facadeTextureMode);
            }
        }
        return null;
    }

    @MCVersionDependentBehaviour
    private static BlockState readBlockState(CompoundTag tag, @Nullable Level level) {
        HolderLookup.RegistryLookup holderGetter = level != null ? level.m_246945_(Registries.f_256747_) : BuiltInRegistries.f_256975_.m_255303_();
        return NbtUtils.m_247651_((HolderGetter)holderGetter, (CompoundTag)tag);
    }
}

