/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.program.IOutputResourceTracker;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceLimit;

public class SharedQuantitySharedRetentionOutputResourceTracker
implements IOutputResourceTracker {
    private final ResourceLimit resource_limit;
    private final ResourceIdSet exclusions;
    private long transferred = 0L;
    private long retention_obligation_progress = 0L;

    public SharedQuantitySharedRetentionOutputResourceTracker(ResourceLimit resourceLimit, ResourceIdSet exclusions) {
        this.resource_limit = resourceLimit;
        this.exclusions = exclusions;
    }

    @Override
    public ResourceLimit getResourceLimit() {
        return this.resource_limit;
    }

    @Override
    public ResourceIdSet getExclusions() {
        return this.exclusions;
    }

    @Override
    public <STACK, CAP, ITEM> boolean isDone(ResourceType<STACK, ITEM, CAP> type, STACK stack) {
        long max_transfer = this.resource_limit.limit().quantity().number().value();
        if (this.transferred >= max_transfer) {
            return true;
        }
        long max_put = this.resource_limit.limit().retention().number().value();
        return this.retention_obligation_progress >= max_put;
    }

    @Override
    public <STACK, ITEM, CAP> void updateRetentionObservation(ResourceType<STACK, ITEM, CAP> type, STACK observed) {
        if (this.matchesStack(observed)) {
            this.retention_obligation_progress += type.getAmount(observed);
        }
    }

    @Override
    public <STACK, ITEM, CAP> void trackTransfer(ResourceType<STACK, ITEM, CAP> resourceType, STACK key, long amount) {
        this.transferred += amount;
        this.retention_obligation_progress += amount;
    }

    @Override
    public <STACK, ITEM, CAP> long getMaxTransferable(ResourceType<STACK, ITEM, CAP> resourceType, STACK key) {
        long max_transfer = this.resource_limit.limit().quantity().number().value();
        long unusedQuantity = max_transfer - this.transferred;
        long max_retain = this.resource_limit.limit().retention().number().value();
        long remainingRetentionRoom = max_retain - this.retention_obligation_progress;
        return Math.min(unusedQuantity, remainingRetentionRoom);
    }

    public String toString() {
        return "SharedQuantitySharedRetentionOutputResourceTracker@" + Integer.toHexString(System.identityHashCode(this)) + "{TRANSFERRED=" + this.transferred + ", RETENTION_OBLIGATION_PROGRESS=" + this.retention_obligation_progress + ", RESOURCE_LIMIT=" + this.resource_limit + ", EXCLUSIONS=" + this.exclusions + "}";
    }
}

