/*
 * Decompiled with CFR 0.152.
 */
package org.simmetrics.builders;

import com.google.common.base.Preconditions;
import com.google.common.collect.Multiset;
import java.util.List;
import java.util.Set;
import org.simmetrics.Distance;
import org.simmetrics.StringDistance;
import org.simmetrics.simplifiers.Simplifier;
import org.simmetrics.simplifiers.Simplifiers;
import org.simmetrics.tokenizers.Tokenizer;

final class StringDistances {
    public static StringDistance create(Distance<String> distance) {
        if (distance instanceof StringDistance) {
            return (StringDistance)distance;
        }
        return new ForString(distance);
    }

    public static StringDistance create(Distance<String> distance, Simplifier simplifier) {
        if (distance instanceof ForString) {
            ForString forString = (ForString)distance;
            return new ForStringWithSimplifier(forString.getDistance(), simplifier);
        }
        if (distance instanceof ForStringWithSimplifier) {
            ForStringWithSimplifier fsws = (ForStringWithSimplifier)distance;
            return new ForStringWithSimplifier(fsws.getDistance(), Simplifiers.chain(simplifier, fsws.getSimplifier()));
        }
        if (distance instanceof ForList) {
            ForList fl = (ForList)distance;
            return StringDistances.createForListDistance(fl.getDistance(), simplifier, fl.getTokenizer());
        }
        if (distance instanceof ForListWithSimplifier) {
            ForListWithSimplifier fl = (ForListWithSimplifier)distance;
            return StringDistances.createForListDistance(fl.getDistance(), Simplifiers.chain(simplifier, fl.getSimplifier()), fl.getTokenizer());
        }
        if (distance instanceof ForSet) {
            ForSet fl = (ForSet)distance;
            return StringDistances.createForSetDistance(fl.getDistance(), simplifier, fl.getTokenizer());
        }
        if (distance instanceof ForSetWithSimplifier) {
            ForSetWithSimplifier fl = (ForSetWithSimplifier)distance;
            return StringDistances.createForSetDistance(fl.getDistance(), Simplifiers.chain(simplifier, fl.getSimplifier()), fl.getTokenizer());
        }
        return new ForStringWithSimplifier(distance, simplifier);
    }

    public static StringDistance createForListDistance(Distance<List<String>> distance, Simplifier simplifier, Tokenizer tokenizer) {
        return new ForListWithSimplifier(distance, simplifier, tokenizer);
    }

    public static StringDistance createForListDistance(Distance<List<String>> distance, Tokenizer tokenizer) {
        return new ForList(distance, tokenizer);
    }

    public static StringDistance createForSetDistance(Distance<Set<String>> distance, Simplifier simplifier, Tokenizer tokenizer) {
        return new ForSetWithSimplifier(distance, simplifier, tokenizer);
    }

    public static StringDistance createForSetDistance(Distance<Set<String>> distance, Tokenizer tokenizer) {
        return new ForSet(distance, tokenizer);
    }

    public static StringDistance createForMultisetDistance(Distance<Multiset<String>> distance, Simplifier simplifier, Tokenizer tokenizer) {
        return new ForMultisetWithSimplifier(distance, simplifier, tokenizer);
    }

    public static StringDistance createForMultisetDistance(Distance<Multiset<String>> distance, Tokenizer tokenizer) {
        return new ForMultiset(distance, tokenizer);
    }

    private StringDistances() {
    }

    static final class ForString
    implements StringDistance {
        private final Distance<String> distance;

        ForString(Distance<String> distance) {
            this.distance = distance;
        }

        @Override
        public float distance(String a, String b) {
            return this.distance.distance(a, b);
        }

        public String toString() {
            return this.distance.toString();
        }

        Distance<String> getDistance() {
            return this.distance;
        }
    }

    static final class ForStringWithSimplifier
    implements StringDistance {
        private final Distance<String> distance;
        private final Simplifier simplifier;

        ForStringWithSimplifier(Distance<String> distance, Simplifier simplifier) {
            Preconditions.checkNotNull(distance);
            Preconditions.checkNotNull((Object)simplifier);
            this.distance = distance;
            this.simplifier = simplifier;
        }

        @Override
        public float distance(String a, String b) {
            return this.distance.distance(this.simplifier.simplify(a), this.simplifier.simplify(b));
        }

        Distance<String> getDistance() {
            return this.distance;
        }

        Simplifier getSimplifier() {
            return this.simplifier;
        }

        public String toString() {
            return this.distance + " [" + this.simplifier + "]";
        }
    }

    static final class ForList
    implements StringDistance {
        private final Distance<List<String>> distance;
        private final Tokenizer tokenizer;

        ForList(Distance<List<String>> distance, Tokenizer tokenizer) {
            Preconditions.checkNotNull(distance);
            Preconditions.checkNotNull((Object)tokenizer);
            this.distance = distance;
            this.tokenizer = tokenizer;
        }

        @Override
        public float distance(String a, String b) {
            return this.distance.distance(this.tokenizer.tokenizeToList(a), this.tokenizer.tokenizeToList(b));
        }

        Distance<List<String>> getDistance() {
            return this.distance;
        }

        Tokenizer getTokenizer() {
            return this.tokenizer;
        }

        public String toString() {
            return this.distance + " [" + this.tokenizer + "]";
        }
    }

    static final class ForListWithSimplifier
    implements StringDistance {
        private final Distance<List<String>> distance;
        private final Simplifier simplifier;
        private final Tokenizer tokenizer;

        ForListWithSimplifier(Distance<List<String>> distance, Simplifier simplifier, Tokenizer tokenizer) {
            Preconditions.checkNotNull(distance);
            Preconditions.checkNotNull((Object)simplifier);
            Preconditions.checkNotNull((Object)tokenizer);
            this.distance = distance;
            this.simplifier = simplifier;
            this.tokenizer = tokenizer;
        }

        @Override
        public float distance(String a, String b) {
            return this.distance.distance(this.tokenizer.tokenizeToList(this.simplifier.simplify(a)), this.tokenizer.tokenizeToList(this.simplifier.simplify(b)));
        }

        Distance<List<String>> getDistance() {
            return this.distance;
        }

        Simplifier getSimplifier() {
            return this.simplifier;
        }

        Tokenizer getTokenizer() {
            return this.tokenizer;
        }

        public String toString() {
            return this.distance + " [" + this.simplifier + " -> " + this.tokenizer + "]";
        }
    }

    static final class ForSet
    implements StringDistance {
        private final Distance<Set<String>> distance;
        private final Tokenizer tokenizer;

        ForSet(Distance<Set<String>> distance, Tokenizer tokenizer) {
            Preconditions.checkNotNull(distance);
            Preconditions.checkNotNull((Object)tokenizer);
            this.distance = distance;
            this.tokenizer = tokenizer;
        }

        @Override
        public float distance(String a, String b) {
            return this.distance.distance(this.tokenizer.tokenizeToSet(a), this.tokenizer.tokenizeToSet(b));
        }

        Distance<Set<String>> getDistance() {
            return this.distance;
        }

        Tokenizer getTokenizer() {
            return this.tokenizer;
        }

        public String toString() {
            return this.distance + " [" + this.tokenizer + "]";
        }
    }

    static final class ForSetWithSimplifier
    implements StringDistance {
        private final Distance<Set<String>> distance;
        private final Simplifier simplifier;
        private final Tokenizer tokenizer;

        ForSetWithSimplifier(Distance<Set<String>> distance, Simplifier simplifier, Tokenizer tokenizer) {
            Preconditions.checkNotNull(distance);
            Preconditions.checkNotNull((Object)simplifier);
            Preconditions.checkNotNull((Object)tokenizer);
            this.distance = distance;
            this.simplifier = simplifier;
            this.tokenizer = tokenizer;
        }

        @Override
        public float distance(String a, String b) {
            return this.distance.distance(this.tokenizer.tokenizeToSet(this.simplifier.simplify(a)), this.tokenizer.tokenizeToSet(this.simplifier.simplify(b)));
        }

        Distance<Set<String>> getDistance() {
            return this.distance;
        }

        Simplifier getSimplifier() {
            return this.simplifier;
        }

        Tokenizer getTokenizer() {
            return this.tokenizer;
        }

        public String toString() {
            return this.distance + " [" + this.simplifier + " -> " + this.tokenizer + "]";
        }
    }

    static final class ForMultisetWithSimplifier
    implements StringDistance {
        private final Distance<Multiset<String>> distance;
        private final Simplifier simplifier;
        private final Tokenizer tokenizer;

        ForMultisetWithSimplifier(Distance<Multiset<String>> distance, Simplifier simplifier, Tokenizer tokenizer) {
            Preconditions.checkNotNull(distance);
            Preconditions.checkNotNull((Object)simplifier);
            Preconditions.checkNotNull((Object)tokenizer);
            this.distance = distance;
            this.simplifier = simplifier;
            this.tokenizer = tokenizer;
        }

        @Override
        public float distance(String a, String b) {
            return this.distance.distance(this.tokenizer.tokenizeToMultiset(this.simplifier.simplify(a)), this.tokenizer.tokenizeToMultiset(this.simplifier.simplify(b)));
        }

        Distance<Multiset<String>> getDistance() {
            return this.distance;
        }

        Simplifier getSimplifier() {
            return this.simplifier;
        }

        Tokenizer getTokenizer() {
            return this.tokenizer;
        }

        public String toString() {
            return this.distance + " [" + this.simplifier + " -> " + this.tokenizer + "]";
        }
    }

    static final class ForMultiset
    implements StringDistance {
        private final Distance<Multiset<String>> distance;
        private final Tokenizer tokenizer;

        ForMultiset(Distance<Multiset<String>> distance, Tokenizer tokenizer) {
            Preconditions.checkNotNull(distance);
            Preconditions.checkNotNull((Object)tokenizer);
            this.distance = distance;
            this.tokenizer = tokenizer;
        }

        @Override
        public float distance(String a, String b) {
            return this.distance.distance(this.tokenizer.tokenizeToMultiset(a), this.tokenizer.tokenizeToMultiset(b));
        }

        Distance<Multiset<String>> getDistance() {
            return this.distance;
        }

        Tokenizer getTokenizer() {
            return this.tokenizer;
        }

        public String toString() {
            return this.distance + " [" + this.tokenizer + "]";
        }
    }
}

