/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.block;

import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.SFMDirections;
import ca.teamdman.sfm.common.util.Stored;
import ca.teamdman.sfm.common.watertanknetwork.WaterNetworkManager;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import org.jetbrains.annotations.Nullable;

public class WaterTankBlock
extends BaseEntityBlock
implements EntityBlock,
BucketPickup,
LiquidBlockContainer {
    public static final BooleanProperty IN_WATER = BooleanProperty.m_61465_((String)"in_water");

    public WaterTankBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76283_).m_155954_(2.0f).m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)IN_WATER, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6807_(BlockState pState, Level pLevel, @NotStored BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        WaterNetworkManager.onActiveStateChanged(pLevel, pPos, pState);
    }

    public void m_6810_(BlockState pState, Level pLevel, @NotStored BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        WaterNetworkManager.onActiveStateChanged(pLevel, pPos, pNewState);
    }

    public void m_5871_(ItemStack pStack, @Nullable BlockGetter pLevel, List<Component> pTooltip, TooltipFlag pFlag) {
        pTooltip.add((Component)LocalizationKeys.WATER_TANK_ITEM_TOOLTIP_1.getComponent().m_130940_(ChatFormatting.GRAY));
        pTooltip.add((Component)LocalizationKeys.WATER_TANK_ITEM_TOOLTIP_2.getComponent().m_130940_(ChatFormatting.GRAY));
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity m_142194_(@Stored BlockPos pos, BlockState state) {
        return ((BlockEntityType)SFMBlockEntities.WATER_TANK_BLOCK_ENTITY.get()).m_155264_(pos, state);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)IN_WATER, (Comparable)Boolean.valueOf(this.hasWaterNeighbours((LevelAccessor)context.m_43725_(), context.m_8083_())));
    }

    public boolean hasWaterNeighbours(LevelAccessor level, @NotStored BlockPos pos) {
        int neighbourWaterCount = 0;
        BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
        for (Direction direction : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
            target.m_122190_((Vec3i)pos).m_122173_(direction);
            FluidState state = level.m_6425_((BlockPos)target);
            if (!state.m_76170_() || !state.m_205070_(FluidTags.f_13131_) || ++neighbourWaterCount != 2) continue;
            return true;
        }
        return false;
    }

    public void m_6861_(BlockState state, Level level, @Stored BlockPos pos, Block blockIn, @Stored BlockPos fromPos, boolean isMoving) {
        if (level.f_46443_) {
            return;
        }
        boolean isActive = this.hasWaterNeighbours((LevelAccessor)level, pos);
        if ((Boolean)state.m_61143_((Property)IN_WATER) != isActive) {
            BlockState newState = (BlockState)this.m_49966_().m_61124_((Property)IN_WATER, (Comparable)Boolean.valueOf(isActive));
            level.m_7731_(pos, newState, 3);
        }
    }

    public ItemStack m_142598_(LevelAccessor level, @NotStored BlockPos pos, BlockState state) {
        return (Boolean)state.m_61143_((Property)IN_WATER) != false ? new ItemStack((ItemLike)Fluids.f_76193_.m_6859_()) : ItemStack.f_41583_;
    }

    public Optional<SoundEvent> m_142298_() {
        return Fluids.f_76193_.m_142520_();
    }

    public boolean m_6044_(BlockGetter level, @NotStored BlockPos pos, BlockState state, Fluid fluid) {
        return fluid.m_6212_((Fluid)Fluids.f_76193_);
    }

    public boolean m_7361_(LevelAccessor level, @NotStored BlockPos pos, BlockState state, FluidState fluid) {
        return fluid.m_76152_().m_6212_((Fluid)Fluids.f_76193_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{IN_WATER});
    }
}

