/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.screen.text_editor;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.ProgramSyntaxHighlightingHelper;
import ca.teamdman.sfm.client.ProgramTokenContextActions;
import ca.teamdman.sfm.client.screen.SFMFontUtils;
import ca.teamdman.sfm.client.screen.SFMScreenChangeHelpers;
import ca.teamdman.sfm.client.screen.SFMScreenRenderUtils;
import ca.teamdman.sfm.client.screen.SFMTextEditorConfigScreen;
import ca.teamdman.sfm.client.text_editor.ISFMTextEditScreenOpenContext;
import ca.teamdman.sfm.client.text_editor.SFMTextEditorIntellisenseLevel;
import ca.teamdman.sfm.client.widget.PickList;
import ca.teamdman.sfm.client.widget.PickListItem;
import ca.teamdman.sfm.client.widget.SFMButtonBuilder;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import ca.teamdman.sfm.common.util.SFMDisplayUtils;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.intellisense.IntellisenseAction;
import ca.teamdman.sfml.intellisense.IntellisenseContext;
import ca.teamdman.sfml.intellisense.SFMLIntellisense;
import ca.teamdman.sfml.manipulation.ManipulationResult;
import ca.teamdman.sfml.manipulation.ProgramStringManipulationUtils;
import ca.teamdman.sfml.program_builder.ProgramBuildResult;
import ca.teamdman.sfml.program_builder.ProgramBuilder;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.MultilineTextField;
import net.minecraft.client.gui.components.Whence;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class SFMTextEditScreenV1
extends Screen {
    private final ISFMTextEditScreenOpenContext openContext;
    protected MyMultiLineEditBox textarea;
    protected String lastProgram = "";
    protected List<MutableComponent> lastProgramWithSyntaxHighlighting = new ArrayList<MutableComponent>();
    protected PickList<IntellisenseAction> suggestedActions;

    public SFMTextEditScreenV1(ISFMTextEditScreenOpenContext openContext) {
        super((Component)LocalizationKeys.TEXT_EDIT_SCREEN_TITLE.getComponent());
        this.openContext = openContext;
    }

    public static MutableComponent substring(MutableComponent component, int start, int end) {
        MutableComponent rtn = Component.empty();
        AtomicInteger seen = new AtomicInteger(0);
        component.visit((style, content) -> {
            int contentEnd;
            int contentStart = Math.max(start - seen.get(), 0);
            if (contentStart < (contentEnd = Math.min(end - seen.get(), content.length()))) {
                rtn.append((Component)Component.literal((String)content.substring(contentStart, contentEnd)).withStyle(style));
            }
            seen.addAndGet(content.length());
            return Optional.empty();
        }, Style.EMPTY);
        return rtn;
    }

    public void scrollToTop() {
        this.textarea.scrollToTop();
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void saveAndClose() {
        this.openContext.onSaveAndClose(this.textarea.getValue());
    }

    public void onClose() {
        this.openContext.onTryClose(this.textarea.getValue(), SFMScreenChangeHelpers::popScreen);
    }

    public void onIntellisensePreferenceChanged() {
        this.textarea.rebuildIntellisense();
    }

    public boolean keyReleased(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 341 || pKeyCode == 345) {
            this.textarea.rebuild(Screen.hasControlDown());
            return true;
        }
        return false;
    }

    public boolean charTyped(char pCodePoint, int pModifiers) {
        if (Screen.hasControlDown() && pCodePoint == ' ') {
            return true;
        }
        if (!this.suggestedActions.isEmpty() && pCodePoint == '\\') {
            return true;
        }
        return super.charTyped(pCodePoint, pModifiers);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if ((pKeyCode == 257 || pKeyCode == 335) && Screen.hasShiftDown()) {
            this.saveAndClose();
            return true;
        }
        if (pKeyCode == 258) {
            String content = this.textarea.getValue();
            int cursor = this.textarea.getCursorPosition();
            int selectionCursor = this.textarea.getSelectionCursorPosition();
            double scrollAmount = this.textarea.getScrollAmount();
            ManipulationResult result = Screen.hasShiftDown() ? ProgramStringManipulationUtils.deindent(content, cursor, selectionCursor) : ProgramStringManipulationUtils.indent(content, cursor, selectionCursor);
            this.textarea.setValue(result.content());
            this.textarea.setCursorPosition(result.cursorPosition());
            this.textarea.setSelectionCursorPosition(result.selectionCursorPosition());
            this.textarea.setScrollAmount(scrollAmount);
            return true;
        }
        if (pKeyCode == 92 && !this.suggestedActions.isEmpty()) {
            IntellisenseAction action = this.suggestedActions.getSelected();
            assert (action != null);
            ManipulationResult result = action.perform(new IntellisenseContext(ProgramBuilder.build(this.textarea.getValue()), this.textarea.getCursorPosition(), this.textarea.getSelectionCursorPosition(), this.openContext.labelPositionHolder(), (SFMTextEditorIntellisenseLevel)((Object)SFMConfig.CLIENT_TEXT_EDITOR_CONFIG.intellisenseLevel.get())));
            double scrollAmount = this.textarea.getScrollAmount();
            this.textarea.setValue(result.content());
            this.textarea.setSelectionCursorPosition(result.selectionCursorPosition());
            this.textarea.setCursorPosition(result.cursorPosition());
            this.textarea.setScrollAmount(scrollAmount);
            return true;
        }
        if (pKeyCode == 341 || pKeyCode == 345) {
            this.textarea.rebuild(Screen.hasControlDown());
            return true;
        }
        if (pKeyCode == 47 && Screen.hasControlDown()) {
            String content = this.textarea.getValue();
            int cursor = this.textarea.getCursorPosition();
            int selectionCursor = this.textarea.getSelectionCursorPosition();
            ManipulationResult result = ProgramStringManipulationUtils.toggleComments(content, cursor, selectionCursor);
            this.textarea.setValue(result.content());
            this.textarea.setCursorPosition(result.cursorPosition());
            this.textarea.setSelectionCursorPosition(result.selectionCursorPosition());
            return true;
        }
        if (pKeyCode == 32 && Screen.hasControlDown()) {
            ProgramTokenContextActions.getContextAction(this.textarea.getValue(), this.textarea.getCursorPosition()).ifPresent(Runnable::run);
            this.textarea.rebuild(false);
            return true;
        }
        if (!(pKeyCode != 265 && pKeyCode != 264 || this.suggestedActions.getItems().isEmpty())) {
            if (pKeyCode == 265) {
                this.suggestedActions.selectPreviousWrapping();
            } else {
                this.suggestedActions.selectNextWrapping();
            }
            return true;
        }
        if (pKeyCode == 256 && !this.suggestedActions.isEmpty()) {
            this.suggestedActions.clear();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void resize(Minecraft mc, int x, int y) {
        String prev = this.textarea.getValue();
        this.init(mc, x, y);
        super.resize(mc, x, y);
        this.textarea.setValue(prev);
    }

    @MCVersionDependentBehaviour
    public void render(GuiGraphics graphics, int mx, int my, float partialTicks) {
        this.renderTransparentBackground(graphics);
        super.render(graphics, mx, my, partialTicks);
    }

    private static boolean shouldShowLineNumbers() {
        return (Boolean)SFMConfig.getOrDefault(SFMConfig.CLIENT_TEXT_EDITOR_CONFIG.showLineNumbers);
    }

    protected void renderTooltip(PoseStack pose, int mx, int my) {
        if (Minecraft.getInstance().screen != this) {
            this.renderables.stream().filter(AbstractWidget.class::isInstance).map(AbstractWidget.class::cast).forEach(w -> w.setFocused(false));
            return;
        }
        this.drawChildTooltips(pose, mx, my);
    }

    @MCVersionDependentBehaviour
    private void drawChildTooltips(PoseStack pose, int mx, int my) {
    }

    protected void init() {
        super.init();
        SFMScreenRenderUtils.enableKeyRepeating();
        this.textarea = (MyMultiLineEditBox)this.addRenderableWidget((GuiEventListener)new MyMultiLineEditBox());
        Objects.requireNonNull(this.font);
        this.suggestedActions = (PickList)this.addRenderableWidget((GuiEventListener)new PickList(this.font, 0, 0, 180, 9 * 6, (Component)LocalizationKeys.INTELLISENSE_PICK_LIST_GUI_TITLE.getComponent(), new ArrayList()));
        this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition(this.width / 2 - 200, this.height / 2 - 100 + 195).setSize(16, 20).setText((Component)Component.literal((String)"#")).setOnPress(button -> {
            int cursorPos = this.textarea.getCursorPosition();
            int selectionCursorPos = this.textarea.getSelectionCursorPosition();
            SFMScreenChangeHelpers.setOrPushScreen(new SFMTextEditorConfigScreen(this, SFMConfig.CLIENT_TEXT_EDITOR_CONFIG, () -> {
                this.setInitialFocus((GuiEventListener)this.textarea);
                this.textarea.setCursorPosition(cursorPos);
                this.textarea.setSelectionCursorPosition(selectionCursorPos);
            }));
        }).setTooltip((Screen)this, this.font, LocalizationKeys.PROGRAM_EDIT_SCREEN_CONFIG_BUTTON_TOOLTIP).build());
        this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition(this.width / 2 - 2 - 150, this.height / 2 - 100 + 195).setSize(200, 20).setText(CommonComponents.GUI_DONE).setOnPress(button -> this.saveAndClose()).setTooltip((Screen)this, this.font, LocalizationKeys.PROGRAM_EDIT_SCREEN_DONE_BUTTON_TOOLTIP).build());
        this.addRenderableWidget((GuiEventListener)new SFMButtonBuilder().setPosition(this.width / 2 - 2 + 100, this.height / 2 - 100 + 195).setSize(100, 20).setText(CommonComponents.GUI_CANCEL).setOnPress(button -> this.onClose()).build());
        this.textarea.setValue(this.openContext.initialValue());
        this.setInitialFocus((GuiEventListener)this.textarea);
    }

    protected class MyMultiLineEditBox
    extends MultiLineEditBox {
        private int frame;

        public MyMultiLineEditBox() {
            super(SFMTextEditScreenV1.this.font, SFMTextEditScreenV1.this.width / 2 - 200, SFMTextEditScreenV1.this.height / 2 - 110, 400, 200, (Component)Component.literal((String)""), (Component)Component.literal((String)""));
            this.frame = 0;
            this.textField.setValueListener(this::onValueOrCursorChanged);
            this.textField.setCursorListener(() -> this.onValueOrCursorChanged(this.textField.value()));
        }

        public void scrollToTop() {
            this.setScrollAmount(0.0);
        }

        public int getCursorPosition() {
            return this.textField.cursor;
        }

        public void setCursorPosition(int cursor) {
            this.textField.seekCursor(Whence.ABSOLUTE, cursor);
        }

        public int getLineNumberWidth() {
            if (SFMTextEditScreenV1.shouldShowLineNumbers()) {
                return this.font.width("000");
            }
            return 0;
        }

        public int getScrollBarHeight() {
            int rtn = super.getScrollBarHeight();
            if (rtn == this.height) {
                return rtn - 1;
            }
            return rtn;
        }

        @MCVersionDependentBehaviour
        public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
            try {
                boolean rtn;
                if (pMouseX >= (double)(this.getX() + 1) && pMouseX <= (double)(this.getX() + this.width - 1)) {
                    pMouseX -= (double)this.getLineNumberWidth();
                }
                if (!this.visible) {
                    rtn = false;
                } else {
                    boolean flag1;
                    boolean flag = this.withinContentAreaPoint(pMouseX, pMouseY);
                    boolean bl = flag1 = this.scrollbarVisible() && pMouseX >= (double)(this.getX() + this.width) && pMouseX <= (double)(this.getX() + this.width + 8) && pMouseY >= (double)this.getY() && pMouseY < (double)(this.getY() + this.height);
                    if (flag1 && pButton == 0) {
                        this.scrolling = true;
                        rtn = true;
                    } else {
                        rtn = false;
                    }
                }
                if (rtn) {
                    return true;
                }
                if (this.withinContentAreaPoint(pMouseX, pMouseY) && pButton == 0) {
                    this.textField.setSelecting(Screen.hasShiftDown());
                    this.seekCursorScreen(pMouseX, pMouseY);
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                SFM.LOGGER.error("Error in SFMTextEditScreenV1.MyMultiLineEditBox.mouseClicked", (Throwable)e);
                return false;
            }
        }

        public int getInnerHeight() {
            Objects.requireNonNull(this.font);
            return 9 * (SFMTextEditScreenV1.this.lastProgramWithSyntaxHighlighting.size() + 2);
        }

        public boolean mouseDragged(double mx, double my, int button, double dx, double dy) {
            int thisX = SFMScreenRenderUtils.getX((AbstractWidget)this);
            if (mx >= (double)(thisX + 1) && mx <= (double)(thisX + this.width - 1)) {
                mx -= (double)this.getLineNumberWidth();
            }
            return super.mouseDragged(mx, my, button, dx, dy);
        }

        public int getSelectionCursorPosition() {
            return this.textField.selectCursor;
        }

        public void setSelectionCursorPosition(int cursor) {
            this.textField.selectCursor = cursor;
        }

        public double getScrollAmount() {
            return this.scrollAmount();
        }

        public void setScrollAmount(double d) {
            super.setScrollAmount(d);
        }

        protected int getMaxScrollAmount() {
            return Math.max(1, super.getMaxScrollAmount());
        }

        private void onValueOrCursorChanged(String programString) {
            int cursorPosition = this.getCursorPosition();
            ProgramBuildResult buildResult = ProgramBuilder.build(programString);
            IntellisenseContext intellisenseContext = new IntellisenseContext(buildResult, cursorPosition, this.getSelectionCursorPosition(), SFMTextEditScreenV1.this.openContext.labelPositionHolder(), (SFMTextEditorIntellisenseLevel)((Object)SFMConfig.CLIENT_TEXT_EDITOR_CONFIG.intellisenseLevel.get()));
            List<IntellisenseAction> suggestions = SFMLIntellisense.getSuggestions(intellisenseContext);
            SFMTextEditScreenV1.this.suggestedActions.setItems(suggestions);
            String cursorWord = buildResult.getWordAtCursorPosition(cursorPosition);
            SFMTextEditScreenV1.this.suggestedActions.setQuery((Component)Component.literal((String)cursorWord));
            boolean shouldPrint = false;
            if (shouldPrint) {
                String cursorPositionDisplay = SFMDisplayUtils.getCursorPositionDisplay(programString, cursorPosition);
                String cursorTokenDisplay = SFMDisplayUtils.getCursorTokenDisplay(buildResult, cursorPosition);
                @Nullable Program program = buildResult.program();
                String tokenHierarchyDisplay = program == null ? "<INVALID PROGRAM>" : SFMDisplayUtils.getTokenHierarchyDisplay(program, cursorPosition);
                String suggestionsDisplay = SFMTextEditScreenV1.this.suggestedActions.getItems().stream().map(PickListItem::getComponent).map(Component::getString).collect(Collectors.joining(", "));
                SFM.LOGGER.info("PROGRAM OR CURSOR CHANGE! {}   {}   {}  |||  {} ||| {}", (Object)cursorPositionDisplay, (Object)cursorTokenDisplay, (Object)tokenHierarchyDisplay, (Object)cursorWord, (Object)suggestionsDisplay);
            }
        }

        private void rebuildIntellisense() {
            this.onValueOrCursorChanged(this.getValue());
        }

        private void rebuild(boolean showContextActionHints) {
            SFMTextEditScreenV1.this.lastProgram = this.textField.value();
            SFMTextEditScreenV1.this.lastProgramWithSyntaxHighlighting = ProgramSyntaxHighlightingHelper.withSyntaxHighlighting(SFMTextEditScreenV1.this.lastProgram, showContextActionHints);
        }

        protected void renderContents(GuiGraphics graphics, int mx, int my, float partialTicks) {
            Matrix4f matrix4f = graphics.pose().last().pose();
            if (!SFMTextEditScreenV1.this.lastProgram.equals(this.textField.value())) {
                this.rebuild(Screen.hasControlDown());
            }
            List<MutableComponent> lines = SFMTextEditScreenV1.this.lastProgramWithSyntaxHighlighting;
            boolean isCursorVisible = this.isFocused() && this.frame++ / 60 % 2 == 0;
            boolean isCursorAtEndOfLine = false;
            int cursorIndex = this.textField.cursor();
            int lineX = SFMScreenRenderUtils.getX((AbstractWidget)this) + this.innerPadding() + this.getLineNumberWidth();
            int lineY = SFMScreenRenderUtils.getY((AbstractWidget)this) + this.innerPadding();
            int charCount = 0;
            int cursorX = 0;
            int cursorY = 0;
            MultilineTextField.StringView selectedRange = this.textField.getSelected();
            int selectionStart = selectedRange.beginIndex();
            int selectionEnd = selectedRange.endIndex();
            for (int line = 0; line < lines.size(); ++line) {
                MutableComponent componentColoured = lines.get(line);
                int lineLength = componentColoured.getString().length();
                Objects.requireNonNull(this.font);
                int lineHeight = 9;
                boolean cursorOnThisLine = isCursorVisible && cursorIndex >= charCount && cursorIndex <= charCount + lineLength;
                MultiBufferSource.BufferSource buffer = MultiBufferSource.immediate((BufferBuilder)Tesselator.getInstance().getBuilder());
                if (SFMTextEditScreenV1.shouldShowLineNumbers()) {
                    String lineNumber = String.valueOf(line + 1);
                    SFMFontUtils.drawInBatch(lineNumber, this.font, (float)(lineX - 2 - this.font.width(lineNumber)), (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                }
                if (cursorOnThisLine) {
                    isCursorAtEndOfLine = cursorIndex == charCount + lineLength;
                    cursorY = lineY;
                    cursorX = SFMFontUtils.drawInBatch((Component)SFMTextEditScreenV1.substring(componentColoured, 0, cursorIndex - charCount), this.font, (float)lineX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer) - 1;
                    SFMTextEditScreenV1.this.suggestedActions.setXY(cursorX + 10, cursorY);
                    SFMFontUtils.drawInBatch((Component)SFMTextEditScreenV1.substring(componentColoured, cursorIndex - charCount, lineLength), this.font, (float)cursorX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                } else {
                    SFMFontUtils.drawInBatch((Component)componentColoured, this.font, (float)lineX, (float)lineY, true, false, matrix4f, (MultiBufferSource)buffer);
                }
                buffer.endBatch();
                if (selectionStart <= charCount + lineLength && selectionEnd > charCount) {
                    int lineSelectionStart = Math.max(selectionStart - charCount, 0);
                    int lineSelectionEnd = Math.min(selectionEnd - charCount, lineLength);
                    int highlightStartX = this.font.width((FormattedText)SFMTextEditScreenV1.substring(componentColoured, 0, lineSelectionStart));
                    int highlightEndX = this.font.width((FormattedText)SFMTextEditScreenV1.substring(componentColoured, 0, lineSelectionEnd));
                    SFMScreenRenderUtils.renderHighlight(graphics, lineX + highlightStartX, lineY, lineX + highlightEndX, lineY + lineHeight);
                }
                lineY += lineHeight;
                charCount += lineLength + 1;
            }
            if (isCursorAtEndOfLine) {
                SFMFontUtils.draw(graphics, this.font, "_", cursorX, cursorY, -1, true);
            } else {
                graphics.fill(cursorX, cursorY - 1, cursorX + 1, cursorY + 1 + 9, -1);
            }
        }
    }
}

