/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.containermenu;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.item.DiskItem;
import ca.teamdman.sfm.common.logging.TranslatableLogEvent;
import ca.teamdman.sfm.common.registry.SFMMenus;
import java.util.ArrayDeque;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ManagerContainerMenu
extends AbstractContainerMenu {
    public final Container CONTAINER;
    public final Inventory PLAYER_INVENTORY;
    public final BlockPos MANAGER_POSITION;
    public final ArrayDeque<TranslatableLogEvent> logs;
    public String logLevel;
    public boolean isLogScreenOpen = false;
    public String program;
    public ManagerBlockEntity.State state;
    public long[] tickTimeNanos;

    public ManagerContainerMenu(int windowId, Inventory inv, Container container, BlockPos blockEntityPos, String program, String logLevel, ManagerBlockEntity.State state, long[] tickTimeNanos, ArrayDeque<TranslatableLogEvent> logs) {
        super(SFMMenus.MANAGER_MENU.get(), windowId);
        ManagerContainerMenu.checkContainerSize((Container)container, (int)1);
        this.CONTAINER = container;
        this.PLAYER_INVENTORY = inv;
        this.MANAGER_POSITION = blockEntityPos;
        this.logLevel = logLevel;
        this.logs = logs;
        this.program = program;
        this.state = state;
        this.tickTimeNanos = tickTimeNanos;
        this.addSlot(new Slot(container, 0, 15, 47){

            public int getMaxStackSize() {
                return 1;
            }

            public boolean mayPlace(ItemStack stack) {
                return stack.getItem() instanceof DiskItem;
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)inv, k, 8 + k * 18, 142));
        }
    }

    public ManagerContainerMenu(int windowId, Inventory inventory, FriendlyByteBuf buf) {
        this(windowId, inventory, (Container)new SimpleContainer(1), buf.readBlockPos(), buf.readUtf(32367), buf.readUtf(64), (ManagerBlockEntity.State)buf.readEnum(ManagerBlockEntity.State.class), buf.readLongArray(null, 20), new ArrayDeque<TranslatableLogEvent>());
    }

    public ManagerContainerMenu(int windowId, Inventory inventory, ManagerBlockEntity manager) {
        this(windowId, inventory, (Container)manager, manager.getBlockPos(), manager.getProgramStringOrEmptyIfNull(), manager.logger.getLogLevel().name(), manager.getState(), manager.getTickTimeNanos(), new ArrayDeque<TranslatableLogEvent>());
    }

    public static void encode(ManagerBlockEntity manager, FriendlyByteBuf buf) {
        buf.writeBlockPos(manager.getBlockPos());
        buf.writeUtf(manager.getProgramStringOrEmptyIfNull(), 32367);
        buf.writeUtf(manager.logger.getLogLevel().name(), 64);
        buf.writeEnum((Enum)manager.getState());
        buf.writeLongArray(manager.getTickTimeNanos());
    }

    public ItemStack getDisk() {
        return this.CONTAINER.getItem(0);
    }

    public boolean stillValid(Player player) {
        return this.CONTAINER.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        int containerEnd = this.CONTAINER.getContainerSize();
        int inventoryEnd = this.slots.size();
        ItemStack contents = slot.getItem();
        ItemStack result = contents.copy();
        if (slotIndex < containerEnd ? !this.moveItemStackTo(contents, containerEnd, inventoryEnd, true) : !this.moveItemStackTo(contents, 0, containerEnd, false)) {
            return ItemStack.EMPTY;
        }
        if (contents.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        return result;
    }
}

