/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.item;

import ca.teamdman.sfm.client.ClientKeyHelpers;
import ca.teamdman.sfm.client.ProgramSyntaxHighlightingHelper;
import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.client.screen.SFMScreenChangeHelpers;
import ca.teamdman.sfm.client.text_editor.SFMTextEditScreenDiskOpenContext;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundDiskItemSetProgramPacket;
import ca.teamdman.sfm.common.program.linting.ProgramLinter;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.util.SFMEnvironmentUtils;
import ca.teamdman.sfm.common.util.SFMItemUtils;
import ca.teamdman.sfm.common.util.SFMTranslationUtils;
import ca.teamdman.sfml.ast.Program;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiskItem
extends Item {
    public DiskItem() {
        super(new Item.Properties());
    }

    public static String getProgram(ItemStack stack) {
        return stack.getOrCreateTag().getString("sfm:program");
    }

    public static void setProgram(ItemStack stack, String program) {
        program = program.replaceAll("\r", "");
        stack.getOrCreateTag().putString("sfm:program", program);
    }

    public static void pruneIfDefault(ItemStack stack) {
        if (DiskItem.getProgram(stack).isBlank() && LabelPositionHolder.from(stack).isEmpty()) {
            for (String key : (String[])stack.getOrCreateTag().getAllKeys().toArray(String[]::new)) {
                stack.removeTagKey(key);
            }
        }
    }

    @Nullable
    public static Program compileAndUpdateErrorsAndWarnings(ItemStack stack, @Nullable ManagerBlockEntity manager) {
        if (manager != null) {
            manager.logger.info(x -> x.accept(LocalizationKeys.PROGRAM_COMPILE_FROM_DISK_BEGIN.get()));
        }
        AtomicReference<Object> rtn = new AtomicReference<Object>(null);
        Program.compile(DiskItem.getProgram(stack), successProgram -> {
            ArrayList<TranslatableContents> warnings = ProgramLinter.gatherWarnings(successProgram, LabelPositionHolder.from(stack), manager);
            if (manager != null) {
                manager.logger.info(x -> x.accept(LocalizationKeys.PROGRAM_COMPILE_SUCCEEDED_WITH_WARNINGS.get(successProgram.name(), warnings.size())));
                manager.logger.warn(warnings::forEach);
            }
            DiskItem.setProgramName(stack, successProgram.name());
            DiskItem.setWarnings(stack, warnings);
            DiskItem.setErrors(stack, Collections.emptyList());
            rtn.set(successProgram);
        }, errors -> {
            List<TranslatableContents> warnings = Collections.emptyList();
            if (manager != null) {
                manager.logger.error(x -> x.accept(LocalizationKeys.PROGRAM_COMPILE_FAILED_WITH_ERRORS.get(errors.size())));
                manager.logger.error(errors::forEach);
            }
            DiskItem.setWarnings(stack, warnings);
            DiskItem.setErrors(stack, errors);
        });
        return rtn.get();
    }

    public static List<TranslatableContents> getErrors(ItemStack stack) {
        return stack.getOrCreateTag().getList("sfm:errors", 10).stream().map(CompoundTag.class::cast).map(SFMTranslationUtils::deserializeTranslation).toList();
    }

    public static void setErrors(ItemStack stack, List<TranslatableContents> errors) {
        stack.getOrCreateTag().put("sfm:errors", (Tag)errors.stream().map(SFMTranslationUtils::serializeTranslation).collect(ListTag::new, AbstractList::add, AbstractCollection::addAll));
    }

    public static List<TranslatableContents> getWarnings(ItemStack stack) {
        return stack.getOrCreateTag().getList("sfm:warnings", 10).stream().map(CompoundTag.class::cast).map(SFMTranslationUtils::deserializeTranslation).collect(Collectors.toList());
    }

    public static void setWarnings(ItemStack stack, List<TranslatableContents> warnings) {
        stack.getOrCreateTag().put("sfm:warnings", (Tag)warnings.stream().map(SFMTranslationUtils::serializeTranslation).collect(ListTag::new, AbstractList::add, AbstractCollection::addAll));
    }

    public static String getProgramName(ItemStack stack) {
        return stack.getOrCreateTag().getString("sfm:name");
    }

    public static void setProgramName(ItemStack stack, String name) {
        if (stack.getItem() instanceof DiskItem) {
            stack.getOrCreateTag().putString("sfm:name", name);
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.getItemInHand(pUsedHand);
        if (pLevel.isClientSide) {
            SFMScreenChangeHelpers.showProgramEditScreen(new SFMTextEditScreenDiskOpenContext(DiskItem.getProgram(stack), LabelPositionHolder.from(stack), newProgramString -> SFMPackets.sendToServer(new ServerboundDiskItemSetProgramPacket((String)newProgramString, pUsedHand))));
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)pLevel.isClientSide());
    }

    public Component getName(ItemStack stack) {
        if (SFMEnvironmentUtils.isClient() && ClientKeyHelpers.isKeyDownInScreenOrWorld(SFMKeyMappings.MORE_INFO_TOOLTIP_KEY)) {
            return super.getName(stack);
        }
        String name = DiskItem.getProgramName(stack);
        if (name.isEmpty()) {
            return super.getName(stack);
        }
        return Component.literal((String)name).withStyle(ChatFormatting.AQUA);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> lines, TooltipFlag detail) {
        String program = DiskItem.getProgram(stack);
        if (SFMItemUtils.isClientAndMoreInfoKeyPressed() && !program.isEmpty()) {
            lines.add((Component)SFMItemUtils.getRainbow(this.getName(stack).getString().length()));
            lines.addAll(ProgramSyntaxHighlightingHelper.withSyntaxHighlighting(program, false));
        } else {
            lines.addAll(LabelPositionHolder.from(stack).asHoverText());
            DiskItem.getErrors(stack).stream().map(MutableComponent::create).map(line -> line.withStyle(ChatFormatting.RED)).forEach(lines::add);
            DiskItem.getWarnings(stack).stream().map(MutableComponent::create).map(line -> line.withStyle(ChatFormatting.YELLOW)).forEach(lines::add);
            if (!program.isEmpty()) {
                SFMItemUtils.appendMoreInfoKeyReminderTextIfOnClient(lines);
            }
        }
        if (program.isEmpty()) {
            lines.add((Component)LocalizationKeys.DISK_EDIT_IN_HAND_TOOLTIP.getComponent().withStyle(ChatFormatting.GRAY));
        }
    }
}

