/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.registry;

import ca.teamdman.sfm.common.net.ClientboundBoolExprStatementInspectionResultsPacket;
import ca.teamdman.sfm.common.net.ClientboundClientConfigCommandPacket;
import ca.teamdman.sfm.common.net.ClientboundContainerExportsInspectionResultsPacket;
import ca.teamdman.sfm.common.net.ClientboundIfStatementInspectionResultsPacket;
import ca.teamdman.sfm.common.net.ClientboundInputInspectionResultsPacket;
import ca.teamdman.sfm.common.net.ClientboundLabelInspectionResultsPacket;
import ca.teamdman.sfm.common.net.ClientboundManagerGuiUpdatePacket;
import ca.teamdman.sfm.common.net.ClientboundManagerLogLevelUpdatedPacket;
import ca.teamdman.sfm.common.net.ClientboundManagerLogsPacket;
import ca.teamdman.sfm.common.net.ClientboundOutputInspectionResultsPacket;
import ca.teamdman.sfm.common.net.ClientboundServerConfigCommandPacket;
import ca.teamdman.sfm.common.net.ClientboundShowChangelogPacket;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.net.SFMPacketDaddy;
import ca.teamdman.sfm.common.net.ServerboundBoolExprStatementInspectionRequestPacket;
import ca.teamdman.sfm.common.net.ServerboundContainerExportsInspectionRequestPacket;
import ca.teamdman.sfm.common.net.ServerboundDiskItemSetProgramPacket;
import ca.teamdman.sfm.common.net.ServerboundFacadePacket;
import ca.teamdman.sfm.common.net.ServerboundIfStatementInspectionRequestPacket;
import ca.teamdman.sfm.common.net.ServerboundInputInspectionRequestPacket;
import ca.teamdman.sfm.common.net.ServerboundLabelGunClearPacket;
import ca.teamdman.sfm.common.net.ServerboundLabelGunCycleViewModePacket;
import ca.teamdman.sfm.common.net.ServerboundLabelGunPrunePacket;
import ca.teamdman.sfm.common.net.ServerboundLabelGunSetActiveLabelPacket;
import ca.teamdman.sfm.common.net.ServerboundLabelGunUsePacket;
import ca.teamdman.sfm.common.net.ServerboundLabelInspectionRequestPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerClearLogsPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerFixPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerLogDesireUpdatePacket;
import ca.teamdman.sfm.common.net.ServerboundManagerProgramPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerRebuildPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerResetPacket;
import ca.teamdman.sfm.common.net.ServerboundManagerSetLogLevelPacket;
import ca.teamdman.sfm.common.net.ServerboundNetworkToolToggleOverlayPacket;
import ca.teamdman.sfm.common.net.ServerboundNetworkToolUsePacket;
import ca.teamdman.sfm.common.net.ServerboundOutputInspectionRequestPacket;
import ca.teamdman.sfm.common.net.ServerboundServerConfigRequestPacket;
import ca.teamdman.sfm.common.net.ServerboundServerConfigUpdatePacket;
import java.util.IdentityHashMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;

@Mod.EventBusSubscriber(modid="sfm", bus=Mod.EventBusSubscriber.Bus.MOD)
public class SFMPackets {
    private static final IdentityHashMap<Class<? extends SFMPacket>, SFMPacketDaddy<? extends SFMPacket>> DADDY_MAP = new IdentityHashMap();

    public static <T extends SFMPacket> void registerPacket(IPayloadRegistrar registrar, SFMPacketDaddy<T> packetDaddy) {
        DADDY_MAP.put(packetDaddy.getPacketClass(), packetDaddy);
        ResourceLocation packetId = SFMPackets.getPacketId(packetDaddy.getPacketClass());
        switch (packetDaddy.getPacketDirection()) {
            case SERVERBOUND: {
                registrar.play(packetId, buf -> {
                    Object packet = packetDaddy.decode((FriendlyByteBuf)buf);
                    return new SFMWrappedPacket(packet);
                }, handler -> handler.server((packet, context) -> packet.getDaddy().handleOuter(packet.inner(), context)));
                break;
            }
            case CLIENTBOUND: {
                registrar.play(packetId, buf -> {
                    Object packet = packetDaddy.decode((FriendlyByteBuf)buf);
                    return new SFMWrappedPacket(packet);
                }, handler -> handler.client((packet, context) -> packet.getDaddy().handleOuter(packet.inner(), context)));
            }
        }
    }

    @SubscribeEvent
    public static void register(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar("sfm").versioned("1.0.0");
        SFMPackets.registerPacket(registrar, new ClientboundBoolExprStatementInspectionResultsPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ClientboundClientConfigCommandPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ClientboundContainerExportsInspectionResultsPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ClientboundIfStatementInspectionResultsPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ClientboundInputInspectionResultsPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ClientboundLabelInspectionResultsPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ClientboundManagerGuiUpdatePacket.Daddy());
        SFMPackets.registerPacket(registrar, new ClientboundManagerLogLevelUpdatedPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ClientboundManagerLogsPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ClientboundOutputInspectionResultsPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ClientboundServerConfigCommandPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ClientboundShowChangelogPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundBoolExprStatementInspectionRequestPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundServerConfigRequestPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundContainerExportsInspectionRequestPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundDiskItemSetProgramPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundFacadePacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundIfStatementInspectionRequestPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundInputInspectionRequestPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundLabelGunClearPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundLabelGunPrunePacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundLabelGunCycleViewModePacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundLabelGunSetActiveLabelPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundLabelGunUsePacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundLabelInspectionRequestPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundManagerClearLogsPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundManagerFixPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundManagerLogDesireUpdatePacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundManagerProgramPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundManagerRebuildPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundManagerResetPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundManagerSetLogLevelPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundNetworkToolToggleOverlayPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundNetworkToolUsePacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundOutputInspectionRequestPacket.Daddy());
        SFMPackets.registerPacket(registrar, new ServerboundServerConfigUpdatePacket.Daddy());
    }

    public static void sendToServer(SFMPacket packet) {
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new SFMWrappedPacket<SFMPacket>(packet)});
    }

    public static void sendToPlayer(Supplier<ServerPlayer> player, SFMPacket packet) {
        PacketDistributor.PLAYER.with((Object)player.get()).send(new CustomPacketPayload[]{new SFMWrappedPacket<SFMPacket>(packet)});
    }

    public static void sendToPlayer(ServerPlayer player, SFMPacket packet) {
        PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new SFMWrappedPacket<SFMPacket>(packet)});
    }

    private static ResourceLocation getPacketId(Class<? extends SFMPacket> clazz) {
        return new ResourceLocation("sfm", clazz.getSimpleName().toLowerCase());
    }

    private record SFMWrappedPacket<T extends SFMPacket>(T inner) implements CustomPacketPayload
    {
        public void write(FriendlyByteBuf friendlyByteBuf) {
            this.getDaddy().encode(this.inner, friendlyByteBuf);
        }

        public ResourceLocation id() {
            return SFMPackets.getPacketId(this.inner.getClass());
        }

        public SFMPacketDaddy<T> getDaddy() {
            return DADDY_MAP.get(this.inner.getClass());
        }
    }
}

