/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.resourcetype;

import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.CapabilityConsumer;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.util.Stored;
import ca.teamdman.sfml.ast.DirectionQualifier;
import ca.teamdman.sfml.ast.Label;
import ca.teamdman.sfml.ast.LabelAccess;
import ca.teamdman.sfml.ast.NumberRangeSet;
import ca.teamdman.sfml.ast.ResourceIdentifier;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.capabilities.BlockCapability;
import org.jetbrains.annotations.Nullable;

public abstract class ResourceType<STACK, ITEM, CAP> {
    public final BlockCapability<CAP, @Nullable Direction> CAPABILITY_KIND;

    public ResourceType(BlockCapability<CAP, @Nullable Direction> CAPABILITY_KIND) {
        this.CAPABILITY_KIND = CAPABILITY_KIND;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResourceType)) {
            return false;
        }
        ResourceType that = (ResourceType)o;
        return Objects.equals(this.CAPABILITY_KIND, that.CAPABILITY_KIND);
    }

    public int hashCode() {
        return Objects.hashCode(this.CAPABILITY_KIND);
    }

    public abstract long getAmount(STACK var1);

    public long getAmountDifference(STACK stack1, STACK stack2) {
        return this.getAmount(stack1) - this.getAmount(stack2);
    }

    public abstract STACK getStackInSlot(CAP var1, int var2);

    public abstract STACK extract(CAP var1, int var2, long var3, boolean var5);

    public abstract int getSlots(CAP var1);

    public abstract long getMaxStackSize(STACK var1);

    public abstract long getMaxStackSizeForSlot(CAP var1, int var2);

    public abstract STACK insert(CAP var1, int var2, STACK var3, boolean var4);

    public abstract boolean isEmpty(STACK var1);

    public abstract STACK getEmptyStack();

    public abstract boolean matchesStackType(Object var1);

    public boolean matchesStack(ResourceIdentifier<STACK, ITEM, CAP> resourceId, Object stack) {
        if (!this.matchesStackType(stack)) {
            return false;
        }
        Object stack_ = stack;
        if (this.isEmpty(stack_)) {
            return false;
        }
        ResourceLocation stackId = this.getRegistryKeyForStack(stack_);
        return resourceId.matchesResourceLocation(stackId);
    }

    public abstract boolean matchesCapabilityType(Object var1);

    public void forEachCapability(ProgramContext programContext, LabelAccess labelAccess, CapabilityConsumer<CAP> consumer) {
        programContext.getLogger().trace(x -> x.accept(LocalizationKeys.LOG_RESOURCE_TYPE_GET_CAPABILITIES_BEGIN.get(this.displayAsCode(), this.displayAsCapabilityClass(), labelAccess)));
        DirectionQualifier directions = labelAccess.directions();
        LabelPositionHolder labelPositionHolder = programContext.getLabelPositionHolder();
        ArrayList<Pair<Label, BlockPos>> positions = labelAccess.getLabelledPositions(labelPositionHolder);
        for (Pair<Label, BlockPos> pair : positions) {
            Label label = (Label)pair.getFirst();
            BlockPos pos = (BlockPos)pair.getSecond();
            this.forEachDirectionalCapability(programContext, directions, pos, (dir, cap) -> consumer.accept(label, pos, (Direction)dir, (Object)cap));
        }
    }

    public void forEachDirectionalCapability(ProgramContext programContext, DirectionQualifier directions, @Stored BlockPos pos, BiConsumer<Direction, CAP> consumer) {
        for (Direction dir : directions) {
            @Nullable CAP maybeCap = programContext.getNetwork().getCapability(this.CAPABILITY_KIND, pos, dir, programContext.getLogger());
            if (maybeCap != null) {
                programContext.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_RESOURCE_TYPE_GET_CAPABILITIES_CAP_PRESENT.get(this.displayAsCapabilityClass(), pos, dir)));
                consumer.accept(dir, maybeCap);
                continue;
            }
            programContext.getLogger().error(x -> x.accept(LocalizationKeys.LOG_RESOURCE_TYPE_GET_CAPABILITIES_CAP_NOT_PRESENT.get(this.displayAsCapabilityClass(), pos, dir)));
        }
    }

    public abstract Stream<ResourceLocation> getTagsForStack(STACK var1);

    public Stream<STACK> getStacksInSlots(CAP cap, NumberRangeSet slots) {
        Stream.Builder<STACK> rtn = Stream.builder();
        for (int slot = 0; slot < this.getSlots(cap); ++slot) {
            STACK stack;
            if (!slots.contains(slot) || this.isEmpty(stack = this.getStackInSlot(cap, slot))) continue;
            rtn.add(stack);
        }
        return rtn.build();
    }

    public abstract boolean registryKeyExists(ResourceLocation var1);

    public abstract ResourceLocation getRegistryKeyForStack(STACK var1);

    public abstract ResourceLocation getRegistryKeyForItem(ITEM var1);

    @Nullable
    public abstract ITEM getItemFromRegistryKey(ResourceLocation var1);

    public abstract Set<ResourceLocation> getRegistryKeys();

    public abstract Collection<ITEM> getItems();

    public abstract ITEM getItem(STACK var1);

    public abstract STACK copy(STACK var1);

    public STACK withCount(STACK stack, long count) {
        return this.setCount(this.copy(stack), count);
    }

    public String displayAsCode() {
        ResourceLocation thisKey = SFMResourceTypes.registry().getKey((Object)this);
        return thisKey != null ? thisKey.toString() : "null";
    }

    public String displayAsCapabilityClass() {
        return this.CAPABILITY_KIND.name().toString();
    }

    protected abstract STACK setCount(STACK var1, long var2);
}

