/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.capability;

import ca.teamdman.sfm.common.blockentity.BufferBlockEntity;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityKind;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityProvider;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityResult;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BufferBlockCapabilityProvider
implements SFMBlockCapabilityProvider<Object> {
    @Override
    public boolean matchesCapabilityKind(SFMBlockCapabilityKind<?> capabilityKind) {
        return capabilityKind.getResourceType() != null;
    }

    @Override
    public SFMBlockCapabilityResult<Object> getCapability(SFMBlockCapabilityKind<Object> capabilityKind, LevelAccessor level, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, @Nullable Direction direction) {
        if (!(blockEntity instanceof BufferBlockEntity)) {
            return SFMBlockCapabilityResult.empty();
        }
        BufferBlockEntity bufferBlockEntity = (BufferBlockEntity)blockEntity;
        ResourceType resourceType = capabilityKind.getResourceType();
        if (resourceType == null) {
            return SFMBlockCapabilityResult.empty();
        }
        return bufferBlockEntity.getContents().getCapability(resourceType);
    }
}

