/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.net.ClientboundInputInspectionResultsPacket;
import ca.teamdman.sfm.common.net.ClientboundOutputInspectionResultsPacket;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.util.Stored;
import ca.teamdman.sfml.ast.Program;
import ca.teamdman.sfml.program_builder.ProgramBuilder;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class SFMPacketHandlingContext {
    private final NetworkEvent.Context inner;

    public SFMPacketHandlingContext(Supplier<NetworkEvent.Context> inner) {
        this.inner = inner.get();
    }

    @Nullable
    public ServerPlayer sender() {
        return this.inner.getSender();
    }

    public void finish() {
        this.inner.setPacketHandled(true);
    }

    public void enqueueAndFinish(Runnable runnable) {
        this.inner.enqueueWork(runnable);
        this.finish();
    }

    public <MENU extends AbstractContainerMenu, BE extends BlockEntity> void handleServerboundContainerPacket(Class<MENU> menuClass, Class<BE> blockEntityClass, @Stored BlockPos pos, int containerId, BiConsumer<MENU, BE> callback) {
        SFMPacketHandlingContext.handleServerboundContainerPacket(this, menuClass, blockEntityClass, pos, containerId, callback);
    }

    public static <MENU extends AbstractContainerMenu, BE extends BlockEntity> void handleServerboundContainerPacket(SFMPacketHandlingContext ctx, Class<MENU> menuClass, Class<BE> blockEntityClass, @Stored BlockPos pos, int containerId, BiConsumer<MENU, BE> callback) {
        ServerPlayer sender = ctx.sender();
        if (sender == null) {
            SFM.LOGGER.warn("Invalid packet received: no sender");
            return;
        }
        if (sender.isSpectator()) {
            SFM.LOGGER.warn("Invalid packet received from {}: sender is spectator", (Object)sender.getName().getString());
            return;
        }
        AbstractContainerMenu menu = sender.containerMenu;
        if (!menuClass.isInstance(menu)) {
            SFM.LOGGER.warn("Invalid packet received from {}: menu is not instance of expected class", (Object)sender.getName().getString());
            return;
        }
        if (menu.containerId != containerId) {
            SFM.LOGGER.warn("Invalid packet received from {}: containerId does not match", (Object)sender.getName().getString());
            return;
        }
        Level level = sender.level();
        if (level == null) {
            SFM.LOGGER.warn("Invalid packet received from {}: level is null", (Object)sender.getName().getString());
            return;
        }
        if (!level.isLoaded(pos)) {
            SFM.LOGGER.warn("Invalid packet received from {}: block entity is not loaded", (Object)sender.getName().getString());
            return;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!blockEntityClass.isInstance(blockEntity)) {
            SFM.LOGGER.warn("Invalid packet received from {}: block entity is not instance of expected class", (Object)sender.getName().getString());
            return;
        }
        callback.accept(menu, blockEntity);
    }

    public void compileAndThen(String programString, boolean willMutateProgram, ProgramConsumer callback) {
        ManagerBlockEntity mbe;
        BlockEntity blockEntity;
        ServerPlayer player = this.sender();
        if (player == null) {
            return;
        }
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof ManagerContainerMenu) {
            ManagerContainerMenu mcm = (ManagerContainerMenu)abstractContainerMenu;
            blockEntity = player.level().getBlockEntity(mcm.MANAGER_POSITION);
            if (!(blockEntity instanceof ManagerBlockEntity)) {
                return;
            }
        } else {
            SFMPackets.sendToPlayer(() -> player, (Object)new ClientboundInputInspectionResultsPacket("This inspection is only available when editing inside a manager."));
            return;
        }
        ManagerBlockEntity manager = mbe = (ManagerBlockEntity)blockEntity;
        new ProgramBuilder(programString).useCache(!willMutateProgram).build().caseSuccess((program, metadata) -> callback.accept((Program)program, player, manager)).caseFailure(result -> SFMPackets.sendToPlayer(() -> player, (Object)new ClientboundOutputInspectionResultsPacket("failed to compile program")));
    }

    @FunctionalInterface
    public static interface ProgramConsumer {
        public void accept(Program var1, ServerPlayer var2, ManagerBlockEntity var3);
    }
}

