/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program.linting;

import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.CableNetworkManager;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityDiscovery;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.linting.IProgramLinter;
import ca.teamdman.sfm.common.program.linting.ProblemTracker;
import ca.teamdman.sfml.ast.Program;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import org.jetbrains.annotations.Nullable;

public class LabelNotConnectedProgramLinter
implements IProgramLinter {
    @Override
    public void gatherWarnings(Program program, LabelPositionHolder labels, @Nullable ManagerBlockEntity manager, ProblemTracker tracker) {
        Level level;
        Level level2 = level = manager != null ? manager.getLevel() : null;
        if (level == null) {
            return;
        }
        int before = tracker.size();
        CableNetworkManager.getOrRegisterNetworkFromManagerPosition(manager).ifPresent(network -> {
            block0: for (Map.Entry<String, HashSet<BlockPos>> entry : labels.labels().entrySet()) {
                String label = entry.getKey();
                HashSet<BlockPos> positions = entry.getValue();
                for (BlockPos pos : positions) {
                    if (!(network.isAdjacentToCable(pos) ? !SFMBlockCapabilityDiscovery.hasAnyCapabilityAnyDirection((ILevelExtension)level, pos) && tracker.add(LocalizationKeys.PROGRAM_WARNING_CONNECTED_BUT_NOT_VIABLE_LABEL.get(label, String.format("[%d,%d,%d]", pos.getX(), pos.getY(), pos.getZ()))).isSaturated() : tracker.add(LocalizationKeys.PROGRAM_WARNING_DISCONNECTED_LABEL.get(label, String.format("[%d,%d,%d]", pos.getX(), pos.getY(), pos.getZ()))).isSaturated())) continue;
                    break block0;
                }
            }
        });
        if (tracker.size() > before) {
            tracker.add(LocalizationKeys.PROGRAM_REMINDER_PUSH_LABELS.get());
        }
    }

    @Override
    public void fixWarnings(Program program, LabelPositionHolder labels, ManagerBlockEntity manager, Level level, ItemStack disk) {
        CableNetwork cableNetwork = CableNetworkManager.getOrRegisterNetworkFromManagerPosition(manager).orElse(null);
        if (cableNetwork == null) {
            return;
        }
        labels.removeIf((label, pos) -> !cableNetwork.isAdjacentToCable((BlockPos)pos));
        labels.removeIf((label, pos) -> !SFMBlockCapabilityDiscovery.hasAnyCapabilityAnyDirection((ILevelExtension)level, pos));
    }
}

