/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.watertanknetwork;

import ca.teamdman.sfm.common.block.WaterTankBlock;
import ca.teamdman.sfm.common.blockentity.WaterTankBlockEntity;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.SFMDirections;
import ca.teamdman.sfm.common.watertanknetwork.WaterNetwork;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="sfm")
public class WaterNetworkManager {
    private static final Map<Level, Long2ObjectMap<WaterNetwork>> NETWORKS = new Object2ObjectOpenHashMap();

    public static Long2ObjectMap<WaterNetwork> getNetworksForLevel(Level level) {
        return NETWORKS.computeIfAbsent(level, k -> new Long2ObjectOpenHashMap());
    }

    public static void onLoad(WaterTankBlockEntity blockEntity) {
        Level level = blockEntity.getLevel();
        if (level == null || level.isClientSide()) {
            return;
        }
        WaterNetworkManager.onActiveStateChanged(level, blockEntity.getBlockPos(), blockEntity.getBlockState());
    }

    private static void addMember(Level level, @NotStored BlockPos pos) {
        if (level.isClientSide()) {
            return;
        }
        WaterNetworkManager.getOrRegisterNetwork(level, pos).ifPresent(WaterNetwork::updateMembers);
    }

    private static void removeMember(Level level, @NotStored BlockPos memberPos) {
        if (level.isClientSide()) {
            return;
        }
        WaterNetworkManager.getNetwork(level, memberPos).ifPresent(network -> {
            WaterTankBlockEntity member = network.getMember(memberPos);
            if (member != null) {
                member.setActive(false);
            }
            WaterNetworkManager.removeNetwork(network);
            for (WaterNetwork remainingNetwork : network.withoutMember(memberPos)) {
                WaterNetworkManager.addNetwork(remainingNetwork);
                remainingNetwork.updateMembers();
            }
        });
    }

    public static void onActiveStateChanged(Level level, @NotStored BlockPos pos, BlockState state) {
        if (state.getOptionalValue((Property)WaterTankBlock.IN_WATER).orElse(false).booleanValue()) {
            WaterNetworkManager.addMember(level, pos);
        } else {
            WaterNetworkManager.removeMember(level, pos);
        }
    }

    public static Optional<WaterNetwork> getOrRegisterNetwork(Level level, @NotStored BlockPos pos) {
        if (level.isClientSide()) {
            return Optional.empty();
        }
        Optional<WaterNetwork> existing = WaterNetworkManager.getNetwork(level, pos);
        if (existing.isPresent()) {
            return existing;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof WaterTankBlockEntity)) {
            return Optional.empty();
        }
        WaterTankBlockEntity blockEntity2 = (WaterTankBlockEntity)blockEntity;
        if (!((Boolean)level.getBlockState(pos).getValue((Property)WaterTankBlock.IN_WATER)).booleanValue()) {
            return Optional.empty();
        }
        Set<WaterNetwork> candidates = WaterNetworkManager.getAdjacentNetworks(level, pos);
        if (candidates.isEmpty()) {
            WaterNetwork network = new WaterNetwork(level);
            network.rebuildNetwork(pos);
            WaterNetworkManager.addNetwork(network);
            return Optional.of(network);
        }
        if (candidates.size() == 1) {
            WaterNetwork network = candidates.iterator().next();
            network.addMember(pos);
            WaterNetworkManager.getNetworksForLevel(level).put(pos.asLong(), (Object)network);
            return Optional.of(network);
        }
        WaterNetwork result = WaterNetworkManager.mergeNetworks(candidates, blockEntity2);
        return Optional.ofNullable(result);
    }

    public static void clear() {
        NETWORKS.clear();
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload event) {
        if (event.getLevel().isClientSide()) {
            return;
        }
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        ChunkAccess chunk = event.getChunk();
        WaterNetworkManager.purgeChunk(level, chunk);
    }

    @SubscribeEvent
    public static void onLevelUnload(LevelEvent.Unload event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        NETWORKS.remove(level);
    }

    public static void purgeChunk(ServerLevel level, ChunkAccess chunkAccess) {
        WaterNetworkManager.getNetworksForLevel((Level)level).values().forEach(network -> network.purgeChunk(chunkAccess));
    }

    private static Optional<WaterNetwork> getNetwork(Level level, @NotStored BlockPos pos) {
        WaterNetwork network = (WaterNetwork)WaterNetworkManager.getNetworksForLevel(level).get(pos.asLong());
        return Optional.ofNullable(network);
    }

    private static void removeNetwork(WaterNetwork network) {
        WaterNetworkManager.getNetworksForLevel(network.level()).keySet().removeAll((LongCollection)network.members().keySet());
    }

    private static void addNetwork(WaterNetwork network) {
        Long2ObjectMap<WaterNetwork> networksForLevel = WaterNetworkManager.getNetworksForLevel(network.level());
        network.members().keySet().forEach(pos -> networksForLevel.put(pos, (Object)network));
    }

    private static Set<WaterNetwork> getAdjacentNetworks(Level level, @NotStored BlockPos pos) {
        HashSet<WaterNetwork> rtn = new HashSet<WaterNetwork>();
        BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
        for (Direction direction : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
            target.set((Vec3i)pos).move(direction);
            Optional<WaterNetwork> network = WaterNetworkManager.getNetwork(level, (BlockPos)target);
            network.ifPresent(rtn::add);
        }
        return rtn;
    }

    @Nullable
    private static WaterNetwork mergeNetworks(Set<WaterNetwork> networks, WaterTankBlockEntity blockEntity) {
        if (networks.isEmpty()) {
            return null;
        }
        Iterator<WaterNetwork> iterator = networks.iterator();
        WaterNetwork main = iterator.next();
        iterator.forEachRemaining(main::mergeNetwork);
        main.addMember(blockEntity);
        WaterNetworkManager.addNetwork(main);
        return main;
    }
}

