/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfml.ast;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.program.ProgramBehaviour;
import ca.teamdman.sfm.common.program.ProgramContext;
import ca.teamdman.sfm.common.program.SimulateExploreAllPathsProgramBehaviour;
import ca.teamdman.sfml.ast.ASTNode;
import ca.teamdman.sfml.ast.Block;
import ca.teamdman.sfml.ast.BoolExpr;
import ca.teamdman.sfml.ast.Statement;
import ca.teamdman.sfml.ast.ToStringCondensed;
import java.util.List;
import java.util.function.Predicate;

public record IfStatement(BoolExpr condition, Block trueBlock, Block falseBlock) implements ASTNode,
Statement,
ToStringCondensed
{
    @Override
    public void tick(ProgramContext context) {
        boolean test;
        Predicate<ProgramContext> condition = this.condition;
        ProgramBehaviour programBehaviour = context.getBehaviour();
        if (programBehaviour instanceof SimulateExploreAllPathsProgramBehaviour) {
            SimulateExploreAllPathsProgramBehaviour simulation = (SimulateExploreAllPathsProgramBehaviour)programBehaviour;
            condition = ctx -> {
                int conditionIndex = ctx.getProgram().getConditionIndex(this);
                if (conditionIndex == -1) {
                    SFM.LOGGER.warn("Condition index not found for {}", (Object)this);
                }
                return simulation.getTriggerPathCount().testBit(conditionIndex);
            };
            test = condition.test(context);
            simulation.pushPathElement(new SimulateExploreAllPathsProgramBehaviour.Branch(this, test));
        } else {
            test = condition.test(context);
        }
        if (test) {
            this.tickTrueBlock(context);
        } else {
            this.tickFalseBlock(context);
        }
    }

    @Override
    public String toString() {
        String rtn = "IF " + String.valueOf(this.condition) + " THEN\n" + this.trueBlock.toString().strip().indent(1).stripTrailing();
        if (!this.falseBlock.getStatements().isEmpty()) {
            rtn = rtn + "\nELSE\n" + this.falseBlock.toString().strip().indent(1);
        }
        rtn = rtn + "\nEND";
        return rtn.strip();
    }

    @Override
    public List<Statement> getStatements() {
        return List.of(this.trueBlock, this.falseBlock);
    }

    @Override
    public String toStringCondensed() {
        return this.condition.toString();
    }

    private void tickFalseBlock(ProgramContext context) {
        context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IF_STATEMENT_WAS_FALSE.get(this.condition.toStringPretty())));
        this.falseBlock.tick(context);
    }

    private void tickTrueBlock(ProgramContext context) {
        context.getLogger().debug(x -> x.accept(LocalizationKeys.LOG_PROGRAM_TICK_IF_STATEMENT_WAS_TRUE.get(this.condition.toStringPretty())));
        this.trueBlock.tick(context);
    }
}

