/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.net.SFMPacketDaddy;
import ca.teamdman.sfm.common.net.SFMPacketHandlingContext;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import org.apache.logging.log4j.Level;

public record ServerboundManagerSetLogLevelPacket(int windowId, BlockPos pos, String logLevel) implements SFMPacket
{
    public static final int MAX_LOG_LEVEL_NAME_LENGTH = 64;

    public static class Daddy
    implements SFMPacketDaddy<ServerboundManagerSetLogLevelPacket> {
        @Override
        public SFMPacketDaddy.PacketDirection getPacketDirection() {
            return SFMPacketDaddy.PacketDirection.SERVERBOUND;
        }

        @Override
        public void encode(ServerboundManagerSetLogLevelPacket msg, FriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.m_130130_(msg.windowId());
            friendlyByteBuf.m_130064_(msg.pos());
            friendlyByteBuf.m_130072_(msg.logLevel(), 64);
        }

        @Override
        public ServerboundManagerSetLogLevelPacket decode(FriendlyByteBuf friendlyByteBuf) {
            return new ServerboundManagerSetLogLevelPacket(friendlyByteBuf.m_130242_(), friendlyByteBuf.m_130135_(), friendlyByteBuf.m_130136_(64));
        }

        @Override
        public void handle(ServerboundManagerSetLogLevelPacket msg, SFMPacketHandlingContext context) {
            context.handleServerboundContainerPacket(ManagerContainerMenu.class, ManagerBlockEntity.class, msg.pos, msg.windowId, (menu, manager) -> {
                Level logLevelObj = Level.getLevel((String)msg.logLevel());
                manager.setLogLevel(logLevelObj);
                manager.logger.info(x -> x.accept(LocalizationKeys.LOG_LEVEL_UPDATED.get(msg.logLevel())));
                String sender = "UNKNOWN SENDER";
                ServerPlayer player = context.sender();
                if (player != null) {
                    sender = player.m_7755_().getString();
                }
                SFM.LOGGER.debug("{} updated manager {} {} log level to {}", (Object)sender, (Object)msg.pos(), (Object)manager.m_58904_(), (Object)msg.logLevel());
            });
        }

        @Override
        public Class<ServerboundManagerSetLogLevelPacket> getPacketClass() {
            return ServerboundManagerSetLogLevelPacket.class;
        }
    }
}

