/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.block;

import ca.teamdman.sfm.common.block.BufferBlockTier;
import ca.teamdman.sfm.common.blockentity.BufferBlockEntity;
import ca.teamdman.sfm.common.compat.SFMModCompat;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import ca.teamdman.sfm.common.registry.SFMResourceTypes;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class BufferBlock
extends BaseEntityBlock {
    public static final EnumProperty<ContainedResource> CONTAINED_RESOURCE = EnumProperty.create((String)"resource", ContainedResource.class);
    public final BufferBlockTier tier;

    public BufferBlock(BlockBehaviour.Properties pProperties, BufferBlockTier tier) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue(CONTAINED_RESOURCE, (Comparable)((Object)ContainedResource.Item)));
        this.tier = tier;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return SFMBlockEntities.BUFFER_BLOCK_ENTITY.get().create(pPos, pState);
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue(CONTAINED_RESOURCE, (Comparable)((Object)ContainedResource.Unknown));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        if (pLevel.isClientSide()) {
            return null;
        }
        return BufferBlock.createTickerHelper(pBlockEntityType, SFMBlockEntities.BUFFER_BLOCK_ENTITY.get(), BufferBlockEntity::serverTick);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{CONTAINED_RESOURCE});
    }

    public static enum ContainedResource implements StringRepresentable
    {
        Item,
        Fluid,
        Energy,
        Chemical,
        Redstone,
        Unknown;


        public String getSerializedName() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case Item -> "item";
                case Fluid -> "fluid";
                case Energy -> "energy";
                case Chemical -> "chemical";
                case Redstone -> "redstone";
                case Unknown -> "unknown";
            };
        }

        public static ContainedResource from(ResourceType<?, ?, ?> resourceType) {
            String name = Objects.requireNonNull(SFMResourceTypes.registry().getId(resourceType)).getPath();
            if (name.equals("item")) {
                return Item;
            }
            if (name.equals("fluid")) {
                return Fluid;
            }
            if (name.equals("forge_energy")) {
                return Energy;
            }
            if (name.equals("redstone")) {
                return Redstone;
            }
            if (SFMModCompat.isMekanismLoaded()) {
                if (name.equals("gas") || name.equals("infusion") || name.equals("pigment") || name.equals("slurry")) {
                    return Chemical;
                }
                if (name.equals("mekanism_energy")) {
                    return Energy;
                }
            }
            return Unknown;
        }
    }
}

