/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.block;

import ca.teamdman.sfm.common.block.CableBlock;
import ca.teamdman.sfm.common.block.IFacadableBlock;
import ca.teamdman.sfm.common.facade.FacadeTransparency;
import ca.teamdman.sfm.common.registry.SFMBlockEntities;
import ca.teamdman.sfm.common.registry.SFMBlocks;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.Stored;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.LightBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CableFacadeBlock
extends CableBlock
implements EntityBlock,
IFacadableBlock {
    public CableFacadeBlock(BlockBehaviour.Properties properties) {
        super(properties.lightLevel(LightBlock.LIGHT_EMISSION));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(FacadeTransparency.FACADE_TRANSPARENCY_PROPERTY, (Comparable)((Object)FacadeTransparency.OPAQUE))).setValue((Property)LightBlock.LEVEL, (Comparable)Integer.valueOf(0)));
    }

    @Nullable
    public BlockEntity newBlockEntity(@Stored BlockPos blockPos, BlockState blockState) {
        return SFMBlockEntities.CABLE_FACADE_BLOCK_ENTITY.get().create(blockPos, blockState);
    }

    public VoxelShape getOcclusionShape(BlockState pState, BlockGetter pLevel, @NotStored BlockPos pPos) {
        return pState.getValue(FacadeTransparency.FACADE_TRANSPARENCY_PROPERTY) == FacadeTransparency.TRANSLUCENT ? Shapes.empty() : Shapes.block();
    }

    public ItemStack getCloneItemStack(BlockGetter pLevel, @NotStored BlockPos pPos, BlockState pState) {
        return new ItemStack((ItemLike)SFMBlocks.CABLE_BLOCK.get());
    }

    public boolean propagatesSkylightDown(BlockState pState, BlockGetter pLevel, @NotStored BlockPos pPos) {
        return pState.getValue(FacadeTransparency.FACADE_TRANSPARENCY_PROPERTY) == FacadeTransparency.TRANSLUCENT;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        this.createFacadeBlockStateDefinition(builder);
    }
}

