/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.capability;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.cablenetwork.CableNetwork;
import ca.teamdman.sfm.common.cablenetwork.SFMBlockCapabilityCacheForLevel;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityKind;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityProvider;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityProviderDiscovery;
import ca.teamdman.sfm.common.capability.SFMBlockCapabilityResult;
import ca.teamdman.sfm.common.capability.SFMWellKnownCapabilities;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.logging.TranslatableLogger;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.SFMDirections;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SFMBlockCapabilityDiscovery {
    @NotNull
    public static <CAP> SFMBlockCapabilityResult<CAP> discoverCapabilityFromNetwork(CableNetwork cableNetwork, SFMBlockCapabilityKind<CAP> capKind, @NotStored BlockPos pos, @Nullable Direction direction, TranslatableLogger logger) {
        SFMBlockCapabilityCacheForLevel levelCapabilityCache = cableNetwork.getLevelCapabilityCache();
        SFMBlockCapabilityResult<CAP> cached = SFMBlockCapabilityDiscovery.discoverCapabilityFromCache(capKind, pos, direction, logger, levelCapabilityCache);
        if (cached.isPresent()) {
            return cached;
        }
        if (!cableNetwork.isAdjacentToCable(pos)) {
            logger.warn(x -> x.accept(LocalizationKeys.LOGS_MISSING_ADJACENT_CABLE.get(pos)));
            return SFMBlockCapabilityResult.empty();
        }
        Level level = cableNetwork.getLevel();
        if (!(level instanceof ServerLevel)) {
            return SFMBlockCapabilityResult.empty();
        }
        ServerLevel serverLevel = (ServerLevel)level;
        SFMBlockCapabilityResult<CAP> cap = SFMBlockCapabilityDiscovery.discoverCapabilityFromLevel((LevelAccessor)serverLevel, capKind, pos, direction);
        if (cap.isPresent()) {
            levelCapabilityCache.putCapability(pos, capKind, direction, cap);
        } else {
            logger.warn(x -> x.accept(LocalizationKeys.LOGS_EMPTY_CAPABILITY.get(pos, capKind.getName(), direction)));
        }
        return cap;
    }

    public static boolean hasAnyCapabilityAnyDirection(LevelAccessor level, BlockPos pos) {
        return SFMWellKnownCapabilities.streamCapabilities().filter(cap -> !cap.equals(SFMWellKnownCapabilities.REDSTONE_HANDLER)).anyMatch(cap -> {
            for (Direction direction : SFMDirections.DIRECTIONS_WITH_NULL) {
                if (!SFMBlockCapabilityDiscovery.discoverCapabilityFromLevel(level, cap, pos, direction).isPresent()) continue;
                return true;
            }
            return false;
        });
    }

    @MCVersionDependentBehaviour
    @NotNull
    public static <CAP> SFMBlockCapabilityResult<CAP> discoverCapabilityFromLevel(LevelAccessor level, SFMBlockCapabilityKind<CAP> capKind, @NotStored BlockPos pos, @Nullable Direction direction) {
        BlockState blockState = level.getBlockState(pos);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        try {
            ArrayList<SFMBlockCapabilityProvider<CAP>> providersForKind = SFMBlockCapabilityProviderDiscovery.getCapabilityProvidersForKindFast(capKind);
            for (SFMBlockCapabilityProvider<CAP> capabilityProviderMapper : providersForKind) {
                SFMBlockCapabilityResult<CAP> capability = capabilityProviderMapper.getCapability(capKind, level, pos, blockState, blockEntity, direction);
                if (!capability.isPresent()) continue;
                return capability;
            }
        }
        catch (Throwable t) {
            SFM.LOGGER.error("SFM encountered an exception while querying capabilities. Please report this!\n{}\ncapKind={}\nlevel={}\npos={}\nblockState={}\nblock={}\nblockClass={}\nblockEntity={}\ndirection={}\n".stripTrailing().stripIndent(), (Object)"https://github.com/TeamDman/SuperFactoryManager/issues", capKind, (Object)level, (Object)pos, (Object)blockState, (Object)blockState.getBlock(), blockState.getBlock().getClass(), (Object)blockEntity, (Object)direction);
        }
        return SFMBlockCapabilityResult.empty();
    }

    @NotNull
    private static <CAP> SFMBlockCapabilityResult<CAP> discoverCapabilityFromCache(SFMBlockCapabilityKind<CAP> capKind, @NotStored BlockPos pos, @Nullable Direction direction, TranslatableLogger logger, SFMBlockCapabilityCacheForLevel levelCapabilityCache) {
        SFMBlockCapabilityResult<CAP> found = levelCapabilityCache.getCapability(pos, capKind, direction);
        if (found != null) {
            if (found.isPresent()) {
                logger.trace(x -> x.accept(LocalizationKeys.LOG_CAPABILITY_CACHE_HIT.get(pos, capKind.getName(), direction)));
                return found;
            }
            logger.error(x -> x.accept(LocalizationKeys.LOG_CAPABILITY_CACHE_HIT_INVALID.get(pos, capKind.getName(), direction)));
        } else {
            logger.trace(x -> x.accept(LocalizationKeys.LOG_CAPABILITY_CACHE_MISS.get(pos, capKind.getName(), direction)));
        }
        return SFMBlockCapabilityResult.empty();
    }
}

