/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.item;

import ca.teamdman.sfm.client.render.FormItemExtensions;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.Nullable;

public class FormItem
extends Item {
    public FormItem() {
        super(new Item.Properties());
    }

    public static ItemStack createFormFromReference(ItemStack stack) {
        ItemStack formStack = new ItemStack((ItemLike)SFMItems.FORM_ITEM.get());
        formStack.getOrCreateTag().put("reference", (Tag)stack.serializeNBT());
        formStack.setCount(stack.getCount());
        return formStack;
    }

    @MCVersionDependentBehaviour
    public static ItemStack getBorrowedReferenceFromForm(ItemStack stack) {
        return ItemStack.of((CompoundTag)stack.getOrCreateTag().getCompound("reference"));
    }

    @MCVersionDependentBehaviour
    public static ItemStack getCopiedReferenceFromForm(ItemStack stack) {
        return FormItem.getBorrowedReferenceFromForm(stack);
    }

    @MCVersionDependentBehaviour
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new FormItemExtensions());
    }

    public void appendHoverText(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        ItemStack reference;
        if (pStack.hasTag() && !(reference = FormItem.getBorrowedReferenceFromForm(pStack)).isEmpty()) {
            pTooltipComponents.addAll(reference.getTooltipLines(null, pIsAdvanced));
        }
    }
}

