/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.label;

import ca.teamdman.sfm.common.label.LabelGunPlan;
import ca.teamdman.sfm.common.label.LabelGunPlanTargets;
import ca.teamdman.sfm.common.label.LabelPositionHolder;
import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.net.ServerboundLabelGunUsePacket;
import ca.teamdman.sfm.common.util.ConfirmationParams;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public record LabelGunUnsetBlockLabelsAction(Player player, Level level, ServerboundLabelGunUsePacket msg, ItemStack gunStack, LabelPositionHolder gunLabels, LabelGunPlanTargets targets, String activeLabel) implements LabelGunPlan
{
    @Override
    public void run() {
        if (this.msg.isPickBlockModifierActive()) {
            this.targets.positions().forEach(p -> this.gunLabels.remove(this.activeLabel, (BlockPos)p));
        } else {
            this.targets.positions().forEach(this.gunLabels::removeAll);
        }
        this.gunLabels.save(this.gunStack);
    }

    @Override
    @Nullable
    public ConfirmationParams getConfirmation() {
        if (this.targets.positions().size() <= 1) {
            return null;
        }
        if (this.msg.isPickBlockModifierActive()) {
            return ConfirmationParams.of(LocalizationKeys.REMOVE_ACTIVE_LABEL_CONFIRM_SCREEN_TITLE.getComponent(this.activeLabel), LocalizationKeys.REMOVE_ACTIVE_LABEL_CONFIRM_SCREEN_MESSAGE.getComponent(this.activeLabel, this.targets.positions().size()));
        }
        MutableInt totalLabels = new MutableInt(0);
        this.gunLabels.forEach((label, pos) -> {
            if (this.targets.positions().contains(pos)) {
                totalLabels.increment();
            }
        });
        return ConfirmationParams.of(LocalizationKeys.REMOVE_ALL_LABELS_CONFIRM_SCREEN_TITLE.getComponent(), LocalizationKeys.REMOVE_ALL_LABELS_CONFIRM_SCREEN_MESSAGE.getComponent(totalLabels, this.targets.positions().size()));
    }
}

