/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.program;

import ca.teamdman.sfm.common.program.IInputResourceTracker;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfml.ast.ResourceIdSet;
import ca.teamdman.sfml.ast.ResourceLimit;
import it.unimi.dsi.fastutil.ints.Int2LongArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;

public class SharedQuantitySharedRetentionInputResourceTracker
implements IInputResourceTracker {
    private final ResourceLimit resource_limit;
    private final ResourceIdSet exclusions;
    private final Long2ObjectOpenHashMap<Int2LongArrayMap> retention_obligations_by_pos_by_slot = new Long2ObjectOpenHashMap();
    private long transferred = 0L;
    private long retention_obligation_progress = 0L;

    public SharedQuantitySharedRetentionInputResourceTracker(ResourceLimit resourceLimit, ResourceIdSet exclusions) {
        this.resource_limit = resourceLimit;
        this.exclusions = exclusions;
    }

    @Override
    public <STACK, CAP, ITEM> boolean isDone(ResourceType<STACK, ITEM, CAP> type, STACK stack) {
        long can_transfer = this.resource_limit.limit().quantity().number().value();
        return this.transferred >= can_transfer;
    }

    @Override
    public <STACK, ITEM, CAP> long getRetentionObligationForSlot(ResourceType<STACK, ITEM, CAP> resourceType, STACK key, @NotStored BlockPos pos, int slot) {
        Int2LongArrayMap posEntry = (Int2LongArrayMap)this.retention_obligations_by_pos_by_slot.get(pos.asLong());
        if (posEntry == null) {
            return 0L;
        }
        return posEntry.getOrDefault(slot, 0L);
    }

    @Override
    public <STACK, ITEM, CAP> long getRemainingRetentionObligation(ResourceType<STACK, ITEM, CAP> resourceType, STACK key) {
        return this.resource_limit.limit().retention().number().value() - this.retention_obligation_progress;
    }

    @Override
    public <STACK, ITEM, CAP> void trackRetentionObligation(ResourceType<STACK, ITEM, CAP> resourceType, STACK key, int slot, @NotStored BlockPos pos, long dedicatingToObligation) {
        this.retention_obligation_progress += dedicatingToObligation;
        ((Int2LongArrayMap)this.retention_obligations_by_pos_by_slot.computeIfAbsent(pos.asLong(), k -> new Int2LongArrayMap())).merge(slot, dedicatingToObligation, Long::sum);
    }

    @Override
    public ResourceLimit getResourceLimit() {
        return this.resource_limit;
    }

    @Override
    public ResourceIdSet getExclusions() {
        return this.exclusions;
    }

    @Override
    public <STACK, ITEM, CAP> long getMaxTransferable(ResourceType<STACK, ITEM, CAP> resourceType, STACK stack) {
        return this.resource_limit.limit().quantity().number().value() - this.transferred;
    }

    @Override
    public <STACK, ITEM, CAP> void trackTransfer(ResourceType<STACK, ITEM, CAP> resourceType, STACK stack, long amount) {
        this.transferred += amount;
    }

    public String toString() {
        return "SharedQuantitySharedRetentionInputResourceTracker@" + Integer.toHexString(System.identityHashCode(this)) + "{TRANSFERRED=" + this.transferred + ", RETENTION_OBLIGATION_PROGRESS=" + this.retention_obligation_progress + ", RESOURCE_LIMIT=" + this.resource_limit + ", EXCLUSIONS=" + this.exclusions + "}";
    }
}

