/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.registry;

import ca.teamdman.sfm.common.registry.SFMRegistryWrapper;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.DeferredHolder;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

@MCVersionDependentBehaviour
public class SFMRegistryObject<R, T extends R>
implements Supplier<T> {
    private final ResourceKey<? extends Registry<T>> registryKey;
    private final @UnknownNullability DeferredHolder<R, T> inner;

    public SFMRegistryObject(ResourceKey<? extends Registry<T>> registryKey, @UnknownNullability DeferredHolder<R, T> object) {
        this.registryKey = registryKey;
        this.inner = object;
    }

    public Optional<ResourceKey<T>> getId() {
        return this.getRegistry().getKey(this.get());
    }

    @Nullable
    public String getPath() {
        return this.getId().map(ResourceKey::location).map(ResourceLocation::getPath).orElse(null);
    }

    public SFMRegistryWrapper<T> getRegistry() {
        return new SFMRegistryWrapper(this.registryKey);
    }

    @Override
    public T get() {
        return (T)this.inner.get();
    }

    public final boolean equals(Object o) {
        if (!(o instanceof SFMRegistryObject)) {
            return false;
        }
        SFMRegistryObject that = (SFMRegistryObject)o;
        return this.registryKey.equals(that.registryKey) && this.get().equals(that.get());
    }

    public int hashCode() {
        int result = this.registryKey.hashCode();
        result = 31 * result + this.get().hashCode();
        return result;
    }

    public String toString() {
        return "SFMRegistryObject{registryKey=" + this.registryKey + ", inner=" + this.inner + "}";
    }
}

