/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.timing;

import java.time.Duration;
import org.jetbrains.annotations.NotNull;

public record SFMInstant(long nanos) implements Comparable<SFMInstant>
{
    public static SFMInstant now() {
        return new SFMInstant(SFMInstant.nanoNow());
    }

    public static SFMInstant earliest() {
        return new SFMInstant(Long.MIN_VALUE);
    }

    public static long nanoNow() {
        return System.nanoTime();
    }

    public Duration elapsed() {
        return Duration.ofNanos(SFMInstant.nanoNow() - this.nanos);
    }

    @Override
    public String toString() {
        return "SFMInstant{nanos=" + this.nanos + ", elapsed=" + this.elapsed() + "}";
    }

    @Override
    public int compareTo(@NotNull SFMInstant o) {
        return Long.compare(this.nanos, o.nanos);
    }
}

