/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.util;

import ca.teamdman.sfm.common.localization.LocalizationKeys;
import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;

public class SFMComponentUtils {
    public static MutableComponent substring(Component component, int start, int end) {
        MutableComponent rtn = Component.empty();
        AtomicInteger seen = new AtomicInteger(0);
        component.visit((style, content) -> {
            int contentEnd;
            int contentStart = Math.max(start - seen.get(), 0);
            if (contentStart < (contentEnd = Math.min(end - seen.get(), content.length()))) {
                rtn.append((Component)Component.literal((String)content.substring(contentStart, contentEnd)).withStyle(style));
            }
            seen.addAndGet(content.length());
            return Optional.empty();
        }, Style.EMPTY);
        return rtn;
    }

    public static int length(Component component) {
        AtomicInteger seen = new AtomicInteger(0);
        component.visit(content -> {
            seen.addAndGet(content.length());
            return Optional.empty();
        });
        return seen.get();
    }

    @MCVersionDependentBehaviour
    public static void appendLore(ItemStack stack, Component ... components) {
        CompoundTag displayTag = stack.getOrCreateTag().getCompound("display");
        ListTag lore = displayTag.contains("Lore", 9) ? displayTag.getList("Lore", 8) : new ListTag();
        lore.add((Object)StringTag.valueOf((String)Component.Serializer.toJson((Component)LocalizationKeys.FALLING_ANVIL_JEI_CONSUMED.getComponent())));
        displayTag.put("Lore", (Tag)lore);
        stack.getOrCreateTag().put("display", (Tag)displayTag);
    }
}

