/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.client.registry;

import ca.teamdman.sfm.common.util.MCVersionDependentBehaviour;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.resource.PathPackResources;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, modid="sfm", value={Dist.CLIENT})
public class SFMPackFinders {
    private static final String CLASSIC_PACK_PATH = "pack/classic";
    private static final String CLASSIC_PACK_ID = "sfm:classic";
    private static final String CLASSIC_PACK_DISPLAY_NAME = "SFM Classic";

    @SubscribeEvent
    public static void onRegisterPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() != PackType.CLIENT_RESOURCES) {
            return;
        }
        IModFileInfo modFileInfo = ModList.get().getModFileById("sfm");
        if (modFileInfo == null) {
            return;
        }
        Path classicRoot = modFileInfo.getFile().findResource(new String[]{CLASSIC_PACK_PATH});
        if (!Files.exists(classicRoot.resolve("pack.mcmeta"), new LinkOption[0])) {
            return;
        }
        event.addRepositorySource(consumer -> {
            PathPackResources packResources = new PathPackResources(CLASSIC_PACK_DISPLAY_NAME, true, classicRoot);
            @MCVersionDependentBehaviour Pack pack = Pack.m_245429_((String)CLASSIC_PACK_ID, (Component)Component.m_237113_((String)CLASSIC_PACK_DISPLAY_NAME), (boolean)false, packId -> packResources, (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
            consumer.accept(pack);
        });
    }
}

