/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.resourcetype;

import ca.teamdman.sfm.common.capability.SFMWellKnownCapabilities;
import ca.teamdman.sfm.common.resourcetype.RegistryBackedResourceType;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ItemResourceType
extends RegistryBackedResourceType<ItemStack, Item, IItemHandler> {
    public ItemResourceType() {
        super(SFMWellKnownCapabilities.ITEM_HANDLER);
    }

    @Override
    public IForgeRegistry<Item> getRegistry() {
        return ForgeRegistries.ITEMS;
    }

    @Override
    public Item getItem(ItemStack itemStack) {
        return itemStack.m_41720_();
    }

    @Override
    public ItemStack copy(ItemStack stack) {
        return stack.m_41777_();
    }

    @Override
    public long getAmount(ItemStack stack) {
        return stack.m_41613_();
    }

    @Override
    public ItemStack getStackInSlot(IItemHandler cap, int slot) {
        return cap.getStackInSlot(slot);
    }

    @Override
    public ItemStack extract(IItemHandler handler, int slot, long amount, boolean simulate) {
        int finalAmount = amount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)amount;
        return handler.extractItem(slot, finalAmount, simulate);
    }

    @Override
    public boolean matchesStackType(Object o) {
        return o instanceof ItemStack;
    }

    @Override
    public boolean matchesCapabilityType(Object o) {
        return o instanceof IItemHandler;
    }

    @Override
    public Stream<ResourceLocation> getTagsForStack(ItemStack itemStack) {
        Block block;
        Stream blockTagKeys = !itemStack.m_41619_() ? ((block = Block.m_49814_((Item)itemStack.m_41720_())) != Blocks.f_50016_ ? block.m_204297_().getTagKeys() : Stream.empty()) : Stream.empty();
        Stream itemTagKeys = itemStack.m_41720_().m_204114_().m_203616_();
        return Stream.concat(itemTagKeys, blockTagKeys).map(TagKey::f_203868_);
    }

    @Override
    public int getSlots(IItemHandler handler) {
        return handler.getSlots();
    }

    @Override
    public long getMaxStackSize(ItemStack itemStack) {
        return itemStack.m_41741_();
    }

    @Override
    public long getMaxStackSizeForSlot(IItemHandler handler, int slot) {
        return handler.getSlotLimit(slot);
    }

    @Override
    public ItemStack insert(IItemHandler handler, int slot, ItemStack stack, boolean simulate) {
        if (!simulate) {
            return handler.insertItem(slot, stack, false);
        }
        int grace = 40960;
        int count = stack.m_41613_();
        if (count > Integer.MAX_VALUE - grace) {
            stack.m_41764_(Integer.MAX_VALUE - grace);
            ItemStack rtn = handler.insertItem(slot, stack, true);
            stack.m_41764_(count);
            if (rtn.m_41619_()) {
                rtn = this.copy(stack);
                rtn.m_41764_(grace);
            } else {
                rtn.m_41769_(grace);
            }
            return rtn;
        }
        return handler.insertItem(slot, stack, true);
    }

    @Override
    public boolean isEmpty(ItemStack stack) {
        return stack.m_41619_();
    }

    @Override
    public ItemStack getEmptyStack() {
        return ItemStack.f_41583_;
    }

    @Override
    protected ItemStack setCount(ItemStack stack, long amount) {
        stack.m_41764_((int)Math.min(amount, Integer.MAX_VALUE));
        return stack;
    }
}

