/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.resourcetype;

import ca.teamdman.sfm.common.capability.SFMBlockCapabilityKind;
import ca.teamdman.sfm.common.resourcetype.ResourceType;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.Nullable;

public abstract class RegistryBackedResourceType<STACK, ITEM, CAP>
extends ResourceType<STACK, ITEM, CAP> {
    private final Map<ITEM, ResourceLocation> registryKeyCache = new Object2ObjectOpenHashMap();

    public RegistryBackedResourceType(SFMBlockCapabilityKind<CAP> CAPABILITY_KIND) {
        super(CAPABILITY_KIND);
    }

    @Override
    public ResourceLocation getRegistryKeyForStack(STACK stack) {
        Object item = this.getItem(stack);
        return this.getRegistryKeyForItem(item);
    }

    @Override
    public ResourceLocation getRegistryKeyForItem(ITEM item) {
        ResourceLocation found = this.registryKeyCache.get(item);
        if (found != null) {
            return found;
        }
        found = this.getRegistry().getKey(item);
        if (found == null) {
            throw new NullPointerException("Registry key not found for item: " + item);
        }
        this.registryKeyCache.put(item, found);
        return found;
    }

    @Override
    public Set<ResourceLocation> getRegistryKeys() {
        return this.getRegistry().getKeys();
    }

    @Override
    public Collection<ITEM> getItems() {
        return this.getRegistry().getValues();
    }

    public abstract IForgeRegistry<ITEM> getRegistry();

    @Override
    @Nullable
    public ITEM getItemFromRegistryKey(ResourceLocation location) {
        return (ITEM)this.getRegistry().getValue(location);
    }

    @Override
    public boolean registryKeyExists(ResourceLocation location) {
        return this.getRegistry().containsKey(location);
    }
}

