/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.watertanknetwork;

import ca.teamdman.sfm.common.block.WaterTankBlock;
import ca.teamdman.sfm.common.blockentity.WaterTankBlockEntity;
import ca.teamdman.sfm.common.util.NotStored;
import ca.teamdman.sfm.common.util.SFMDirections;
import ca.teamdman.sfm.common.util.SFMStreamUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArraySet;
import it.unimi.dsi.fastutil.longs.LongCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import org.jetbrains.annotations.Nullable;

public record WaterNetwork(Level level, Long2ObjectOpenHashMap<WaterTankBlockEntity> members, Long2ObjectOpenHashMap<LongArraySet> chunkMemberLookup) {
    public WaterNetwork(Level level) {
        this(level, (Long2ObjectOpenHashMap<WaterTankBlockEntity>)new Long2ObjectOpenHashMap(), (Long2ObjectOpenHashMap<LongArraySet>)new Long2ObjectOpenHashMap());
    }

    public void rebuildNetwork(@NotStored BlockPos start) {
        this.members.clear();
        this.discoverMembers(start).forEach(this::addMember);
        this.updateMembers();
    }

    @Nullable
    public WaterTankBlockEntity getMember(@NotStored BlockPos memberPos) {
        return (WaterTankBlockEntity)((Object)this.members.get(memberPos.m_121878_()));
    }

    public void addMember(@NotStored BlockPos pos) {
        this.addMember((WaterTankBlockEntity)this.level.m_7702_(pos));
    }

    public void addMember(WaterTankBlockEntity blockEntity) {
        this.members.put(blockEntity.m_58899_().m_121878_(), (Object)blockEntity);
        blockEntity.setActive(true);
    }

    public void updateMembers() {
        int size = this.members.size();
        for (WaterTankBlockEntity member : this.members().values()) {
            member.setConnectedCount(size);
        }
    }

    public Stream<WaterTankBlockEntity> discoverMembers(@NotStored BlockPos start) {
        return SFMStreamUtils.getRecursiveStream((current, next, results) -> {
            BlockState blockState;
            BlockEntity patt2183$temp = this.level.m_7702_(current);
            if (!(patt2183$temp instanceof WaterTankBlockEntity)) {
                return;
            }
            WaterTankBlockEntity blockEntity = (WaterTankBlockEntity)patt2183$temp;
            if (!current.equals((Object)start) && !(blockState = this.level.m_8055_(current)).m_61145_((Property)WaterTankBlock.IN_WATER).orElse(false).booleanValue()) {
                return;
            }
            results.accept(blockEntity);
            for (Direction d : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
                next.accept(current.m_121955_(d.m_122436_()));
            }
        }, start);
    }

    public Stream<WaterTankBlockEntity> discoverMembersFromCache(@NotStored BlockPos start, WaterNetwork cache) {
        return SFMStreamUtils.getRecursiveStream((current, next, results) -> {
            WaterTankBlockEntity blockEntity = (WaterTankBlockEntity)((Object)((Object)cache.members.get(current.longValue())));
            if (blockEntity == null) {
                return;
            }
            results.accept(blockEntity);
            BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
            for (Direction d : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
                target.m_122188_(current.longValue()).m_122173_(d);
                next.accept(target.m_121878_());
            }
        }, start.m_121878_());
    }

    public void purgeChunk(ChunkAccess chunkAccess) {
        long chunkKey = chunkAccess.m_7697_().m_45588_();
        LongArraySet memberPositions = (LongArraySet)this.chunkMemberLookup.get(chunkKey);
        if (memberPositions == null) {
            return;
        }
        this.members.keySet().removeAll((LongCollection)memberPositions);
        this.chunkMemberLookup.remove(chunkKey);
    }

    private void rebuildNetworkFromCache(@NotStored BlockPos start, WaterNetwork cache) {
        this.members.clear();
        this.discoverMembersFromCache(start, cache).forEach(this::addMember);
    }

    void mergeNetwork(WaterNetwork other) {
        this.members.putAll(other.members);
    }

    List<WaterNetwork> withoutMember(@NotStored BlockPos pos) {
        this.members.remove(pos.m_121878_());
        ArrayList<WaterNetwork> branches = new ArrayList<WaterNetwork>();
        BlockPos.MutableBlockPos target = new BlockPos.MutableBlockPos();
        for (Direction direction : SFMDirections.DIRECTIONS_WITHOUT_NULL) {
            target.m_122190_((Vec3i)pos).m_122173_(direction);
            long targetKey = target.m_121878_();
            if (!this.members.containsKey(targetKey) || branches.stream().anyMatch(branch -> branch.members.containsKey(targetKey))) continue;
            WaterNetwork branch2 = new WaterNetwork(this.level);
            branch2.rebuildNetworkFromCache((BlockPos)target, this);
            branches.add(branch2);
        }
        return branches;
    }
}

