/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.gametest;

import java.util.ArrayList;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class SFMStructureGenerator {
    public static Optional<StructureTemplate> generateStructureTemplate(ResourceLocation id) {
        StructureTemplate template = new StructureTemplate();
        template.m_74612_("TeamDman");
        template.f_74484_ = SFMStructureGenerator.extractSizeFromTemplateId(id);
        ArrayList<StructureTemplate.StructureBlockInfo> infos = new ArrayList<StructureTemplate.StructureBlockInfo>();
        for (int x = 0; x < template.f_74484_.m_123341_(); ++x) {
            int y = 0;
            for (int z = 0; z < template.f_74484_.m_123343_(); ++z) {
                BlockPos pos = new BlockPos(x, y, z);
                StructureTemplate.StructureBlockInfo blockInfo = new StructureTemplate.StructureBlockInfo(pos, Blocks.f_50387_.m_49966_(), null);
                infos.add(blockInfo);
            }
        }
        template.f_74482_.add(new StructureTemplate.Palette(infos));
        return Optional.of(template);
    }

    private static Vec3i extractSizeFromTemplateId(ResourceLocation id) {
        String regex;
        Matcher matcher;
        int x = 1;
        int y = 1;
        int z = 1;
        String path = id.m_135815_();
        if (path.contains(".")) {
            path = path.split("\\.")[1];
        }
        if ((matcher = Pattern.compile(regex = "([0-9]+)x([0-9]+)x([0-9]+)").matcher(path)).find()) {
            x = Integer.parseInt(matcher.group(1));
            y = Integer.parseInt(matcher.group(2));
            z = Integer.parseInt(matcher.group(3));
        }
        return new Vec3i(x, y, z);
    }
}

